/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.model.validation.node;

import java.util.ArrayList;
import java.util.List;
import software.amazon.smithy.model.node.ObjectNode;
import software.amazon.smithy.model.shapes.MapShape;
import software.amazon.smithy.model.shapes.Shape;
import software.amazon.smithy.model.shapes.ShapeIndex;
import software.amazon.smithy.model.traits.LengthTrait;
import software.amazon.smithy.model.validation.node.MemberAndShapeTraitPlugin;

public final class MapLengthPlugin
extends MemberAndShapeTraitPlugin<MapShape, ObjectNode, LengthTrait> {
    public MapLengthPlugin() {
        super(MapShape.class, ObjectNode.class, LengthTrait.class);
    }

    @Override
    protected List<String> check(Shape shape, LengthTrait trait, ObjectNode node, ShapeIndex index) {
        ArrayList<String> messages = new ArrayList<String>();
        trait.getMin().ifPresent(min -> {
            if ((long)node.size() < min) {
                messages.add(String.format("Value provided for `%s` must have at least %d entries, but the provided value only has %d entries", shape.getId(), min, node.size()));
            }
        });
        trait.getMax().ifPresent(max -> {
            if ((long)node.size() > max) {
                messages.add(String.format("Value provided for `%s` must have no more than %d entries, but the provided value has %d entries", shape.getId(), max, node.size()));
            }
        });
        return messages;
    }
}

