/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.model.validation;

import java.util.Objects;
import java.util.Optional;
import software.amazon.smithy.model.FromSourceLocation;
import software.amazon.smithy.model.SourceException;
import software.amazon.smithy.model.SourceLocation;
import software.amazon.smithy.model.node.Node;
import software.amazon.smithy.model.node.ToNode;
import software.amazon.smithy.model.shapes.Shape;
import software.amazon.smithy.model.shapes.ShapeId;
import software.amazon.smithy.model.shapes.ToShapeId;
import software.amazon.smithy.model.validation.Severity;
import software.amazon.smithy.utils.SmithyBuilder;
import software.amazon.smithy.utils.ToSmithyBuilder;

public final class ValidationEvent
implements ToNode,
ToSmithyBuilder<ValidationEvent> {
    private final SourceLocation sourceLocation;
    private final String message;
    private final String eventId;
    private final Severity severity;
    private final ShapeId shapeId;
    private final String suppressionReason;
    private final String asString;

    private ValidationEvent(Builder builder) {
        if (builder.suppressionReason != null && builder.severity != Severity.SUPPRESSED) {
            throw new IllegalStateException("A suppression reason must only be provided for SUPPRESSED events");
        }
        this.sourceLocation = (SourceLocation)SmithyBuilder.requiredState((String)"sourceLocation", (Object)builder.sourceLocation);
        this.message = (String)SmithyBuilder.requiredState((String)"message", (Object)builder.message);
        this.severity = (Severity)((Object)SmithyBuilder.requiredState((String)"severity", (Object)((Object)builder.severity)));
        this.eventId = (String)SmithyBuilder.requiredState((String)"eventId", (Object)builder.eventId);
        this.shapeId = builder.shapeId;
        this.suppressionReason = builder.suppressionReason;
        this.asString = String.format("[%s] %s: %s | %s %s:%s:%s", new Object[]{this.severity, this.shapeId != null ? this.shapeId : "-", this.message, this.eventId, this.sourceLocation.getFilename(), this.sourceLocation.getLine(), this.sourceLocation.getColumn()});
    }

    public static Builder builder() {
        return new Builder();
    }

    public static ValidationEvent fromSourceException(SourceException exception) {
        return ValidationEvent.fromSourceException(exception, "");
    }

    public static ValidationEvent fromSourceException(SourceException exception, String prefix) {
        return ValidationEvent.builder().eventId("Model").severity(Severity.ERROR).message(prefix + exception.getMessageWithoutLocation()).sourceLocation(exception.getSourceLocation()).build();
    }

    public Builder toBuilder() {
        Builder builder = new Builder();
        builder.sourceLocation = this.sourceLocation;
        builder.message = this.message;
        builder.severity = this.severity;
        builder.eventId = this.eventId;
        builder.shapeId = this.shapeId;
        builder.suppressionReason = this.suppressionReason;
        return builder;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ValidationEvent)) {
            return false;
        }
        ValidationEvent other = (ValidationEvent)o;
        return this.sourceLocation.equals(other.sourceLocation) && this.message.equals(other.message) && this.severity.equals((Object)other.severity) && this.eventId.equals(other.eventId) && this.getShapeId().equals(other.getShapeId()) && this.getSuppressionReason().equals(other.getSuppressionReason());
    }

    public int hashCode() {
        return this.asString.hashCode() + this.getSuppressionReason().hashCode();
    }

    public String toString() {
        return this.asString;
    }

    @Override
    public Node toNode() {
        return Node.objectNodeBuilder().withMember("id", Node.from(this.getEventId())).withMember("severity", Node.from(this.getSeverity().toString())).withOptionalMember("shapeId", this.getShapeId().map(Object::toString).map(Node::from)).withMember("message", Node.from(this.getMessage())).withOptionalMember("suppressionReason", this.getSuppressionReason().map(Node::from)).withMember("filename", Node.from(this.getSourceLocation().getFilename())).withMember("line", Node.from(this.getSourceLocation().getLine())).withMember("column", Node.from(this.getSourceLocation().getColumn())).build();
    }

    public SourceLocation getSourceLocation() {
        return this.sourceLocation;
    }

    public String getMessage() {
        return this.message;
    }

    public Severity getSeverity() {
        return this.severity;
    }

    public String getEventId() {
        return this.eventId;
    }

    public Optional<ShapeId> getShapeId() {
        return Optional.ofNullable(this.shapeId);
    }

    public Optional<String> getSuppressionReason() {
        return Optional.ofNullable(this.suppressionReason);
    }

    public static final class Builder
    implements SmithyBuilder<ValidationEvent> {
        private SourceLocation sourceLocation = SourceLocation.none();
        private String message;
        private Severity severity;
        private String eventId;
        private ShapeId shapeId;
        private String suppressionReason;

        private Builder() {
        }

        public Builder message(String eventMessage) {
            this.message = Objects.requireNonNull(eventMessage);
            return this;
        }

        public Builder message(String eventMessage, Object ... placeholders) {
            return this.message(String.format(eventMessage, placeholders));
        }

        public Builder severity(Severity severity) {
            this.severity = Objects.requireNonNull(severity);
            return this;
        }

        public Builder eventId(String eventId) {
            this.eventId = Objects.requireNonNull(eventId);
            return this;
        }

        public Builder sourceLocation(FromSourceLocation sourceLocation) {
            this.sourceLocation = Objects.requireNonNull(sourceLocation.getSourceLocation());
            return this;
        }

        public <T extends ToShapeId> Builder shapeId(T toShapeId) {
            this.shapeId = toShapeId == null ? null : toShapeId.toShapeId();
            return this;
        }

        public Builder shape(Shape encounteredShape) {
            return this.sourceLocation(Objects.requireNonNull(encounteredShape).getSourceLocation()).shapeId(encounteredShape.getId());
        }

        public Builder suppressionReason(String eventSuppressionReason) {
            this.suppressionReason = eventSuppressionReason;
            return this;
        }

        public ValidationEvent build() {
            return new ValidationEvent(this);
        }
    }
}

