/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.model.pattern;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import software.amazon.smithy.model.pattern.InvalidUriPatternException;
import software.amazon.smithy.model.pattern.Pattern;
import software.amazon.smithy.utils.Pair;

public final class UriPattern
extends Pattern {
    private final Map<String, String> queryLiterals;

    private UriPattern(Pattern.Builder builder, Map<String, String> queryLiterals) {
        super(builder);
        this.queryLiterals = queryLiterals;
    }

    public static UriPattern parse(String uri) {
        if (uri.endsWith("?")) {
            throw new InvalidUriPatternException("URI patterns must not end with '?'. Found " + uri);
        }
        if (!uri.startsWith("/")) {
            throw new InvalidUriPatternException("URI pattern must start with '/'. Found " + uri);
        }
        if (uri.contains("#")) {
            throw new InvalidUriPatternException("URI pattern must not contain a fragment. Found " + uri);
        }
        String[] parts = uri.split(java.util.regex.Pattern.quote("?"), 2);
        String[] unparsedSegments = parts[0].split(java.util.regex.Pattern.quote("/"));
        ArrayList<Pattern.Segment> segments = new ArrayList<Pattern.Segment>();
        int offset = 1;
        for (int i = 1; i < unparsedSegments.length; ++i) {
            String segment = unparsedSegments[i];
            segments.add(Pattern.Segment.parse(segment, offset));
            offset += segment.length();
        }
        LinkedHashMap<String, String> queryLiterals = new LinkedHashMap<String, String>();
        if (parts.length == 2) {
            if (parts[1].contains("{") || parts[1].contains("}")) {
                throw new InvalidUriPatternException("URI labels must not appear in the query string. Found " + uri);
            }
            for (String kvp : parts[1].split(java.util.regex.Pattern.quote("&"))) {
                String[] parameterParts = kvp.split("=", 2);
                String actualKey = parameterParts[0];
                if (queryLiterals.containsKey(actualKey)) {
                    throw new InvalidUriPatternException("Literal query parameters must not be repeated: " + uri);
                }
                queryLiterals.put(actualKey, parameterParts.length == 2 ? parameterParts[1] : "");
            }
        }
        return new UriPattern(UriPattern.builder().pattern(uri).segments(segments), queryLiterals);
    }

    public Map<String, String> getQueryLiterals() {
        return Collections.unmodifiableMap(this.queryLiterals);
    }

    public Optional<String> getQueryLiteralValue(String parameter) {
        return Optional.ofNullable(this.queryLiterals.get(parameter));
    }

    public boolean conflictsWith(UriPattern otherPattern) {
        if (!this.getConflictingLabelSegments(otherPattern).isEmpty()) {
            return true;
        }
        List<Pattern.Segment> segments = this.getSegments();
        List<Pattern.Segment> otherSegments = otherPattern.getSegments();
        if (segments.size() != otherSegments.size()) {
            return false;
        }
        for (int i = 0; i < segments.size(); ++i) {
            Pattern.Segment segment = segments.get(i);
            Pattern.Segment otherSegment = otherSegments.get(i);
            if (segment.isLabel() || otherSegment.isLabel() || segment.getContent().equals(otherSegment.getContent())) continue;
            return false;
        }
        return this.queryLiterals.equals(otherPattern.queryLiterals);
    }

    public List<Pair<Pattern.Segment, Pattern.Segment>> getConflictingLabelSegments(UriPattern otherPattern) {
        ArrayList<Pair<Pattern.Segment, Pattern.Segment>> conflictingSegments = new ArrayList<Pair<Pattern.Segment, Pattern.Segment>>();
        List<Pattern.Segment> segments = this.getSegments();
        List<Pattern.Segment> otherSegments = otherPattern.getSegments();
        int minSize = Math.min(segments.size(), otherSegments.size());
        for (int i = 0; i < minSize; ++i) {
            Pattern.Segment thisSegment = segments.get(i);
            Pattern.Segment otherSegment = otherSegments.get(i);
            if (thisSegment.isLabel() != otherSegment.isLabel()) {
                conflictingSegments.add((Pair<Pattern.Segment, Pattern.Segment>)Pair.of((Object)thisSegment, (Object)otherSegment));
                continue;
            }
            if (thisSegment.isGreedyLabel() != otherSegment.isGreedyLabel()) {
                conflictingSegments.add((Pair<Pattern.Segment, Pattern.Segment>)Pair.of((Object)thisSegment, (Object)otherSegment));
                continue;
            }
            if (thisSegment.isLabel() || thisSegment.getContent().equals(otherSegment.getContent())) continue;
            return conflictingSegments;
        }
        return conflictingSegments;
    }

    @Override
    public boolean equals(Object other) {
        if (!(other instanceof UriPattern)) {
            return false;
        }
        UriPattern otherPattern = (UriPattern)other;
        return super.equals(other) && this.queryLiterals.equals(otherPattern.queryLiterals);
    }

    @Override
    public int hashCode() {
        return super.hashCode() + this.queryLiterals.hashCode();
    }
}

