/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.model.node;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonLocation;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import software.amazon.smithy.model.SourceLocation;
import software.amazon.smithy.model.loader.ModelSyntaxException;
import software.amazon.smithy.model.node.ArrayNode;
import software.amazon.smithy.model.node.BooleanNode;
import software.amazon.smithy.model.node.Node;
import software.amazon.smithy.model.node.NodeFactory;
import software.amazon.smithy.model.node.NullNode;
import software.amazon.smithy.model.node.NumberNode;
import software.amazon.smithy.model.node.ObjectNode;
import software.amazon.smithy.model.node.StringNode;
import software.amazon.smithy.utils.ListUtils;
import software.amazon.smithy.utils.MapUtils;

@Deprecated
public final class DefaultNodeFactory
implements NodeFactory {
    private final JsonFactory jsonFactory;

    public DefaultNodeFactory() {
        this(new JsonFactory());
    }

    DefaultNodeFactory(JsonFactory jsonFactory) {
        this.jsonFactory = jsonFactory;
    }

    @Override
    public Node createNode(String filename, String text) {
        ByteArrayInputStream targetStream = new ByteArrayInputStream(text.getBytes(Charset.forName("UTF-8")));
        return this.createNode(filename, targetStream);
    }

    public Node createNode(String filename, InputStream input) {
        JsonParser parser = this.createParser(filename, input);
        try {
            parser.nextToken();
            Node result = this.parse(filename, parser);
            parser.close();
            return result;
        }
        catch (IOException e) {
            SourceLocation current = this.getSourceLocation(filename, parser);
            String message = filename.isEmpty() ? String.format("Error parsing node: %s", e.getMessage()) : String.format("Error parsing file `%s`: %s", filename, e.getMessage());
            throw new ModelSyntaxException(message, current);
        }
    }

    private JsonParser createParser(String filename, InputStream text) {
        try {
            return this.jsonFactory.createParser(text);
        }
        catch (IOException e) {
            throw new ModelSyntaxException(String.format("Error creating parser for %s: %s", filename, e.getMessage()), new SourceLocation(filename, 1, 1));
        }
    }

    private Node parse(String filename, JsonParser parser) throws IOException {
        JsonToken token = parser.currentToken();
        if (token == null) {
            throw new IOException("Expected token not found");
        }
        SourceLocation sourceLocation = this.getSourceLocation(filename, parser);
        switch (token) {
            case START_OBJECT: {
                return this.parseObject(sourceLocation, parser);
            }
            case START_ARRAY: {
                return this.parseArray(sourceLocation, parser);
            }
            case VALUE_NULL: {
                return new NullNode(sourceLocation);
            }
            case VALUE_TRUE: {
                return new BooleanNode(true, sourceLocation);
            }
            case VALUE_FALSE: {
                return new BooleanNode(false, sourceLocation);
            }
            case VALUE_NUMBER_INT: {
                return new NumberNode(parser.getLongValue(), sourceLocation);
            }
            case VALUE_NUMBER_FLOAT: {
                return new NumberNode(parser.getDoubleValue(), sourceLocation);
            }
            case VALUE_STRING: {
                return new StringNode(parser.getValueAsString(), sourceLocation);
            }
        }
        throw new IOException(String.format("Unexpected token, `%s`", token));
    }

    private SourceLocation getSourceLocation(String filename, JsonParser parser) {
        JsonLocation location = parser.getTokenLocation();
        return new SourceLocation(filename, location.getLineNr(), location.getColumnNr());
    }

    private Node parseObject(SourceLocation sourceLocation, JsonParser parser) throws IOException {
        String filename = sourceLocation.getFilename();
        if (parser.nextToken() == JsonToken.END_OBJECT) {
            return new ObjectNode(MapUtils.of(), sourceLocation, false);
        }
        LinkedHashMap<StringNode, Node> nodes = new LinkedHashMap<StringNode, Node>();
        do {
            String fieldName = parser.getCurrentName();
            StringNode keyNode = new StringNode(fieldName, this.getSourceLocation(filename, parser));
            parser.nextToken();
            nodes.put(keyNode, this.parse(filename, parser));
            parser.nextToken();
        } while (parser.currentToken() != JsonToken.END_OBJECT);
        return new ObjectNode(nodes, sourceLocation);
    }

    private Node parseArray(SourceLocation sourceLocation, JsonParser parser) throws IOException {
        String filename = sourceLocation.getFilename();
        if (parser.nextToken() == JsonToken.END_ARRAY) {
            return new ArrayNode(ListUtils.of(), sourceLocation, false);
        }
        ArrayList<Node> nodes = new ArrayList<Node>();
        do {
            nodes.add(this.parse(filename, parser));
            parser.nextToken();
        } while (parser.currentToken() != JsonToken.END_ARRAY);
        return new ArrayNode(nodes, sourceLocation);
    }
}

