/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.model.loader;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import software.amazon.smithy.model.Model;
import software.amazon.smithy.model.SourceLocation;
import software.amazon.smithy.model.loader.Prelude;
import software.amazon.smithy.model.loader.ValidationLoader;
import software.amazon.smithy.model.loader.ValidatorDefinition;
import software.amazon.smithy.model.loader.ValidatorFromDefinitionFactory;
import software.amazon.smithy.model.validation.Severity;
import software.amazon.smithy.model.validation.Suppression;
import software.amazon.smithy.model.validation.ValidatedResult;
import software.amazon.smithy.model.validation.ValidationEvent;
import software.amazon.smithy.model.validation.Validator;
import software.amazon.smithy.model.validation.ValidatorFactory;
import software.amazon.smithy.utils.ListUtils;

final class ModelValidator {
    private final List<Validator> validators;
    private final List<Suppression> suppressions;
    private final ArrayList<ValidationEvent> events = new ArrayList();
    private final ValidatorFactory validatorFactory;
    private final Model model;

    private ModelValidator(Model model, ValidatorFactory validatorFactory, List<Validator> validators, List<Suppression> suppressions) {
        this.model = model;
        this.validatorFactory = validatorFactory;
        this.validators = new ArrayList<Validator>(validators);
        this.suppressions = new ArrayList<Suppression>(suppressions);
    }

    static List<ValidationEvent> validate(Model model, ValidatorFactory validatorFactory, List<Validator> validators, List<Suppression> suppressions) {
        return new ModelValidator(model, validatorFactory, validators, suppressions).doValidate();
    }

    static List<ValidationEvent> validate(Model model, ValidatorFactory validatorFactory) {
        return ModelValidator.validate(model, validatorFactory, ListUtils.of(), ListUtils.of());
    }

    private List<ValidationEvent> doValidate() {
        List<ValidatorDefinition> assembledValidatorDefinitions = this.assembleValidatorDefinitions();
        this.assembleValidators(assembledValidatorDefinitions);
        this.assembleSuppressions();
        this.events.addAll(this.validators.parallelStream().flatMap(validator -> validator.validate(this.model).stream()).map(event -> Suppression.suppressEvent(event, this.suppressions)).filter(ModelValidator::filterPrelude).collect(Collectors.toList()));
        return this.events;
    }

    private static boolean filterPrelude(ValidationEvent event) {
        return event.getSeverity() == Severity.ERROR || !event.getShapeId().filter(Prelude::isPreludeShape).isPresent();
    }

    private List<ValidatorDefinition> assembleValidatorDefinitions() {
        ValidatedResult<List<ValidatorDefinition>> result = ValidationLoader.loadValidators(this.model.getMetadata());
        this.events.addAll(result.getValidationEvents());
        return result.getResult().orElseGet(Collections::emptyList);
    }

    private void assembleSuppressions() {
        ValidatedResult<List<Suppression>> result = ValidationLoader.loadSuppressions(this.model.getMetadata());
        this.events.addAll(result.getValidationEvents());
        result.getResult().ifPresent(this.suppressions::addAll);
    }

    private void assembleValidators(List<ValidatorDefinition> definitions) {
        ValidatorFromDefinitionFactory factory = new ValidatorFromDefinitionFactory(this.validatorFactory);
        for (ValidatorDefinition val : definitions) {
            ValidatedResult<Validator> result = factory.loadValidator(val);
            result.getResult().ifPresent(this.validators::add);
            this.events.addAll(result.getValidationEvents());
            if (!result.getValidationEvents().isEmpty() || result.getResult().isPresent()) continue;
            this.events.add(this.unknownValidatorError(val.name, val.sourceLocation));
        }
    }

    private ValidationEvent unknownValidatorError(String name, SourceLocation location) {
        return ValidationEvent.builder().eventId("UnknownValidator." + name).severity(Severity.WARNING).sourceLocation(location).message("Unable to locate a validator named `" + name + "`").build();
    }
}

