/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.model.validation.validators;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.smithy.model.Model;
import software.amazon.smithy.model.shapes.Shape;
import software.amazon.smithy.model.shapes.ShapeId;
import software.amazon.smithy.model.traits.Trait;
import software.amazon.smithy.model.validation.AbstractValidator;
import software.amazon.smithy.model.validation.ValidationEvent;

public final class TraitConflictValidator
extends AbstractValidator {
    @Override
    public List<ValidationEvent> validate(Model model) {
        return model.shapes().flatMap(shape -> {
            Map<ShapeId, Trait> traits = shape.getAllTraits();
            HashMap<ShapeId, List<ShapeId>> conflicts = new HashMap<ShapeId, List<ShapeId>>();
            traits.forEach((k, v) -> model.getTraitDefinition(v.toShapeId()).ifPresent(definition -> definition.getConflicts().forEach(conflict -> {
                if (traits.containsKey(conflict)) {
                    conflicts.computeIfAbsent((ShapeId)k, key -> new ArrayList()).add(conflict);
                }
            })));
            return conflicts.isEmpty() ? Stream.empty() : Stream.of(this.foundConflicts((Shape)shape, (Map<ShapeId, List<ShapeId>>)conflicts));
        }).collect(Collectors.toList());
    }

    private ValidationEvent foundConflicts(Shape shape, Map<ShapeId, List<ShapeId>> conflicts) {
        return this.error(shape, "Found conflicting traits on " + (Object)((Object)shape.getType()) + " shape: " + conflicts.entrySet().stream().flatMap(this::lines).sorted().collect(Collectors.joining(", ")));
    }

    private Stream<String> lines(Map.Entry<ShapeId, List<ShapeId>> entry) {
        String prefix = "`" + Trait.getIdiomaticTraitName(entry.getKey()) + "` conflicts with `";
        return entry.getValue().stream().map(value -> prefix + Trait.getIdiomaticTraitName(value) + "`");
    }
}

