/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.model.validation.validators;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import software.amazon.smithy.model.Model;
import software.amazon.smithy.model.shapes.MemberShape;
import software.amazon.smithy.model.shapes.Shape;
import software.amazon.smithy.model.traits.RangeTrait;
import software.amazon.smithy.model.traits.Trait;
import software.amazon.smithy.model.validation.AbstractValidator;
import software.amazon.smithy.model.validation.ValidationEvent;
import software.amazon.smithy.utils.Pair;

public class RangeTraitValidator
extends AbstractValidator {
    @Override
    public List<ValidationEvent> validate(Model model) {
        return model.shapes().flatMap(shape -> Trait.flatMapStream(shape, RangeTrait.class)).flatMap(pair -> this.validateRangeTrait(model, (Shape)pair.getLeft(), (RangeTrait)pair.getRight()).stream()).collect(Collectors.toList());
    }

    private List<ValidationEvent> validateRangeTrait(Model model, Shape shape, RangeTrait trait) {
        ArrayList<ValidationEvent> events = new ArrayList<ValidationEvent>();
        trait.getMin().flatMap(min -> this.validateRangeProperty(model, shape, trait, (BigDecimal)min, "min")).ifPresent(events::add);
        trait.getMax().flatMap(max -> this.validateRangeProperty(model, shape, trait, (BigDecimal)max, "max")).ifPresent(events::add);
        trait.getMin().flatMap(min -> trait.getMax().map(max -> Pair.of((Object)min, (Object)max))).filter(pair -> ((BigDecimal)pair.getLeft()).compareTo((BigDecimal)pair.getRight()) > 0).map(pair -> this.error(shape, trait, "A range trait is applied with a `min` value greater than its `max` value.")).map(events::add);
        return events;
    }

    private Optional<ValidationEvent> validateRangeProperty(Model model, Shape shape, RangeTrait trait, BigDecimal property, String name) {
        if (!property.remainder(BigDecimal.ONE).equals(BigDecimal.ZERO)) {
            if (shape.isMemberShape()) {
                MemberShape member = shape.asMemberShape().get();
                Optional<Shape> target = model.getShape(member.getTarget());
                if (target.isPresent() && !this.isDecimalShape(target.get())) {
                    return Optional.of(this.error(shape, trait, String.format("Member `%s` is marked with the `range` trait, but its `%s` property is a decimal (%s) when its target (`%s`) does not support decimals.", shape.getId(), name, property, target.get().getId())));
                }
            } else if (!this.isDecimalShape(shape)) {
                return Optional.of(this.error(shape, trait, String.format("Shape `%s` is marked with the `range` trait, but its `%s` property is a decimal (%s) when its shape (`%s`) does not support decimals.", new Object[]{shape.getId(), name, property, shape.getType()})));
            }
        }
        return Optional.empty();
    }

    private boolean isDecimalShape(Shape shape) {
        return shape.isFloatShape() || shape.isDoubleShape() || shape.isBigDecimalShape();
    }
}

