/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.model.validation.validators;

import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.smithy.model.Model;
import software.amazon.smithy.model.knowledge.TopDownIndex;
import software.amazon.smithy.model.shapes.OperationShape;
import software.amazon.smithy.model.shapes.ServiceShape;
import software.amazon.smithy.model.traits.AuthTrait;
import software.amazon.smithy.model.traits.Protocol;
import software.amazon.smithy.model.traits.ProtocolsTrait;
import software.amazon.smithy.model.validation.AbstractValidator;
import software.amazon.smithy.model.validation.ValidationEvent;
import software.amazon.smithy.utils.OptionalUtils;

public final class AuthProtocolsValidator
extends AbstractValidator {
    @Override
    public List<ValidationEvent> validate(Model model) {
        TopDownIndex topDownIndex = model.getKnowledge(TopDownIndex.class);
        return model.shapes(ServiceShape.class).flatMap(service -> this.validateOperationAgainstProtocols(topDownIndex, (ServiceShape)service)).collect(Collectors.toList());
    }

    private Stream<ValidationEvent> validateOperationAgainstProtocols(TopDownIndex index, ServiceShape service) {
        ProtocolsTrait protocolsTrait = service.getTrait(ProtocolsTrait.class).orElse(null);
        if (protocolsTrait == null) {
            return Stream.empty();
        }
        return protocolsTrait.getProtocols().stream().flatMap(protocol -> index.getContainedOperations(service).stream().flatMap(operation -> OptionalUtils.stream(this.validateOperationSchemesAgainstProtocols(service, (OperationShape)operation, (Protocol)protocol))));
    }

    private Optional<ValidationEvent> validateOperationSchemesAgainstProtocols(ServiceShape service, OperationShape operation, Protocol protocol) {
        AuthTrait authTrait;
        block5: {
            block4: {
                authTrait = OptionalUtils.or(operation.getTrait(AuthTrait.class), () -> service.getTrait(AuthTrait.class)).orElse(null);
                if (authTrait == null) {
                    return Optional.empty();
                }
                List<String> supportedSchemes = protocol.getAuth();
                List<String> values = authTrait.getValues();
                if (values.contains("none")) break block4;
                if (!values.stream().anyMatch(supportedSchemes::contains)) break block5;
            }
            return Optional.empty();
        }
        return Optional.of(this.warning(operation, String.format("The `auth` trait resolved for this operation, %s, is not compatible with the `%s` protocol of the `%s` service: %s", authTrait.getValues(), protocol.getName(), service.getId(), protocol.getAuth())));
    }
}

