/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.model.validation.testrunner;

import java.io.IOException;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import software.amazon.smithy.model.loader.ModelAssembler;
import software.amazon.smithy.model.validation.testrunner.SmithyTestCase;

public final class SmithyTestSuite {
    private List<Callable<Void>> testCaseCallables = new ArrayList<Callable<Void>>();
    private Supplier<ModelAssembler> modelAssemblerFactory = ModelAssembler::new;
    private final List<SmithyTestCase.Result> failedResults = Collections.synchronizedList(new ArrayList());
    private ExecutorService executorService;

    private SmithyTestSuite() {
    }

    public static SmithyTestSuite runner() {
        return new SmithyTestSuite();
    }

    public SmithyTestSuite addTestCase(SmithyTestCase testCase) {
        this.addTestCaseCallable(testCase);
        return this;
    }

    private void addTestCaseCallable(SmithyTestCase testCase) {
        this.testCaseCallables.add(() -> {
            ModelAssembler assembler = this.modelAssemblerFactory.get();
            assembler.addImport(testCase.getModelLocation());
            SmithyTestCase.Result result = testCase.createResult(assembler.assemble());
            if (result.isInvalid()) {
                this.failedResults.add(result);
            }
            return null;
        });
    }

    public SmithyTestSuite addTestCasesFromDirectory(Path modelDirectory) {
        try {
            Files.walk(modelDirectory, new FileVisitOption[0]).filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).filter(file -> {
                String filename = file.toString();
                return filename.endsWith(".json") || filename.endsWith(".smithy");
            }).map(file -> SmithyTestCase.fromModelFile(file.toString())).forEach(this::addTestCase);
            return this;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public SmithyTestSuite addTestCasesFromUrl(URL url) {
        if (!url.getProtocol().equals("file")) {
            throw new IllegalArgumentException("Only file URLs are supported by the testrunner: " + url);
        }
        try {
            return this.addTestCasesFromDirectory(Paths.get(url.toURI()));
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
    }

    public SmithyTestSuite setModelAssemblerFactory(Supplier<ModelAssembler> modelAssemblerFactory) {
        this.modelAssemblerFactory = Objects.requireNonNull(modelAssemblerFactory);
        return this;
    }

    public SmithyTestSuite setExecutorService(ExecutorService executorService) {
        this.executorService = executorService;
        return this;
    }

    public Result run() {
        this.failedResults.clear();
        if (this.executorService == null) {
            int numberOfCores = Runtime.getRuntime().availableProcessors();
            this.executorService = Executors.newFixedThreadPool(numberOfCores - 1);
        }
        try {
            for (Future<Void> future : this.executorService.invokeAll(this.testCaseCallables)) {
                this.waitOnFuture(future);
            }
            Result result = new Result(this.testCaseCallables.size() - this.failedResults.size(), this.failedResults);
            if (this.failedResults.isEmpty()) {
                Result result2 = result;
                return result2;
            }
            try {
                throw new Error(result);
            }
            catch (InterruptedException e) {
                this.executorService.shutdownNow();
                throw new Error("Error executing test suite: " + e.getMessage(), e);
            }
        }
        finally {
            this.executorService.shutdown();
            this.testCaseCallables.clear();
        }
    }

    private void waitOnFuture(Future<Void> future) throws InterruptedException {
        try {
            future.get();
        }
        catch (ExecutionException e) {
            Throwable cause;
            Throwable throwable = cause = e.getCause() != null ? e.getCause() : e;
            if (cause instanceof RuntimeException) {
                throw (RuntimeException)cause;
            }
            throw new Error("Error executing test case: " + e.getMessage(), cause);
        }
    }

    private static String formatString(String value) {
        return value.replace("\n", "\\n");
    }

    public static final class Error
    extends RuntimeException {
        public final Result result;

        Error(Result result) {
            super(result.toString());
            this.result = result;
        }

        Error(String message, Throwable previous) {
            super(message, previous);
            this.result = new Result(0, Collections.emptyList());
        }
    }

    public static final class Result {
        private final int successCount;
        private final List<SmithyTestCase.Result> failedResults;

        Result(int successCount, List<SmithyTestCase.Result> failedResults) {
            this.successCount = successCount;
            this.failedResults = Collections.unmodifiableList(failedResults);
        }

        public int getSuccessCount() {
            return this.successCount;
        }

        public List<SmithyTestCase.Result> getFailedResults() {
            return this.failedResults;
        }

        public String toString() {
            StringBuilder builder = new StringBuilder(String.format("Smithy validation test runner encountered %d successful result(s), and %d failed result(s)", this.getSuccessCount(), this.getFailedResults().size()));
            this.getFailedResults().forEach(failed -> Result.appendResult(failed, builder));
            return builder.toString();
        }

        private static void appendResult(SmithyTestCase.Result result, StringBuilder builder) {
            builder.append("\n\n============= Model Validation Result =============\n").append(result.getModelLocation()).append("\n");
            if (!result.getUnmatchedEvents().isEmpty()) {
                builder.append("\n* Did not match the following events: \n");
                builder.append(result.getUnmatchedEvents().stream().map(Object::toString).map(x$0 -> SmithyTestSuite.formatString(x$0)).sorted().collect(Collectors.joining("\n")));
                builder.append("\n");
            }
            if (!result.getExtraEvents().isEmpty()) {
                builder.append("\n* Encountered unexpected events: \n");
                builder.append(result.getExtraEvents().stream().map(Object::toString).map(x$0 -> SmithyTestSuite.formatString(x$0)).sorted().collect(Collectors.joining("\n")));
                builder.append("\n");
            }
        }
    }
}

