/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.model.traits;

import software.amazon.smithy.model.FromSourceLocation;
import software.amazon.smithy.model.SourceLocation;
import software.amazon.smithy.model.node.Node;
import software.amazon.smithy.model.node.NumberNode;
import software.amazon.smithy.model.shapes.ShapeId;
import software.amazon.smithy.model.traits.AbstractTrait;
import software.amazon.smithy.model.traits.Trait;

public final class HttpErrorTrait
extends AbstractTrait {
    public static final ShapeId ID = ShapeId.from("smithy.api#httpError");
    private final int code;

    public HttpErrorTrait(int code, FromSourceLocation sourceLocation) {
        super(ID, sourceLocation);
        this.code = code;
    }

    public HttpErrorTrait(int code) {
        this(code, (FromSourceLocation)SourceLocation.NONE);
    }

    public int getCode() {
        return this.code;
    }

    @Override
    protected Node createNode() {
        return new NumberNode(this.code, this.getSourceLocation());
    }

    public static final class Provider
    extends AbstractTrait.Provider {
        public Provider() {
            super(ID);
        }

        @Override
        public Trait createTrait(ShapeId target, Node value) {
            return new HttpErrorTrait(value.expectNumberNode().getValue().intValue(), (FromSourceLocation)value.getSourceLocation());
        }
    }
}

