/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.model.validation.validators;

import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.stream.Collectors;
import software.amazon.smithy.model.Model;
import software.amazon.smithy.model.shapes.MemberShape;
import software.amazon.smithy.model.shapes.Shape;
import software.amazon.smithy.model.shapes.StructureShape;
import software.amazon.smithy.model.traits.HttpHeaderTrait;
import software.amazon.smithy.model.traits.Trait;
import software.amazon.smithy.model.validation.AbstractValidator;
import software.amazon.smithy.model.validation.ValidationEvent;
import software.amazon.smithy.model.validation.ValidationUtils;
import software.amazon.smithy.utils.SetUtils;

public final class HttpHeaderTraitValidator
extends AbstractValidator {
    private static final Set<String> BLACKLIST = SetUtils.of((Object[])new String[]{"authorization", "connection", "content-length", "expect", "host", "max-forwards", "proxy-authenticate", "server", "te", "trailer", "transfer-encoding", "upgrade", "user-agent", "www-authenticate", "x-forwarded-for"});

    @Override
    public List<ValidationEvent> validate(Model model) {
        List<ValidationEvent> events = model.getShapeIndex().shapes(StructureShape.class).flatMap(shape -> this.validateStructure((StructureShape)shape).stream()).collect(Collectors.toList());
        events.addAll(model.getShapeIndex().shapes(MemberShape.class).flatMap(member -> Trait.flatMapStream(member, HttpHeaderTrait.class)).filter(pair -> BLACKLIST.contains(((HttpHeaderTrait)pair.getRight()).getValue().toLowerCase(Locale.US))).map(pair -> this.danger((Shape)pair.getLeft(), String.format("httpHeader cannot be set to `%s`", ((HttpHeaderTrait)pair.getRight()).getValue()))).collect(Collectors.toList()));
        return events;
    }

    private List<ValidationEvent> validateStructure(StructureShape structure) {
        return structure.getAllMembers().values().stream().flatMap(member -> Trait.flatMapStream(member, HttpHeaderTrait.class)).collect(Collectors.groupingBy(pair -> ((HttpHeaderTrait)pair.getRight()).getValue().toLowerCase(Locale.US), Collectors.mapping(pair -> ((MemberShape)pair.getLeft()).getMemberName(), Collectors.toList()))).entrySet().stream().filter(entry -> ((List)entry.getValue()).size() > 1).map(entry -> this.error(structure, String.format("`httpHeader` field name binding conflicts found for the `%s` header in the following structure members: %s", entry.getKey(), ValidationUtils.tickedList((Collection)entry.getValue())))).collect(Collectors.toList());
    }
}

