/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.model.validation.node;

import java.util.List;
import software.amazon.smithy.model.loader.Prelude;
import software.amazon.smithy.model.node.StringNode;
import software.amazon.smithy.model.shapes.Shape;
import software.amazon.smithy.model.shapes.ShapeId;
import software.amazon.smithy.model.shapes.ShapeIdSyntaxException;
import software.amazon.smithy.model.shapes.ShapeIndex;
import software.amazon.smithy.model.shapes.StringShape;
import software.amazon.smithy.model.traits.IdRefTrait;
import software.amazon.smithy.model.validation.node.MemberAndShapeTraitPlugin;
import software.amazon.smithy.utils.ListUtils;

public final class IdRefPlugin
extends MemberAndShapeTraitPlugin<StringShape, StringNode, IdRefTrait> {
    public IdRefPlugin() {
        super(StringShape.class, StringNode.class, IdRefTrait.class);
    }

    @Override
    protected List<String> check(Shape shape, IdRefTrait trait, StringNode node, ShapeIndex index) {
        try {
            String target = node.getValue();
            Shape resolved = Prelude.resolveShapeId(index, shape.getId().getNamespace(), target).orElse(null);
            if (resolved == null) {
                return trait.failWhenMissing() ? this.failWhenNoMatch(trait, String.format("Shape ID `%s` was not found in the model", target)) : ListUtils.of();
            }
            if (this.matchesSelector(trait, resolved.getId(), index)) {
                return ListUtils.of();
            }
            return this.failWhenNoMatch(trait, String.format("Shape ID `%s` does not match selector `%s`", resolved.getId(), trait.getSelector()));
        }
        catch (ShapeIdSyntaxException e) {
            return ListUtils.of((Object)e.getMessage());
        }
    }

    private boolean matchesSelector(IdRefTrait trait, ShapeId needle, ShapeIndex haystack) {
        return trait.getSelector().select(haystack).stream().map(Shape::getId).anyMatch(shapeId -> shapeId.equals(needle));
    }

    private List<String> failWhenNoMatch(IdRefTrait trait, String message) {
        return ListUtils.of((Object)trait.getErrorMessage().orElse(message));
    }
}

