/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.model.transform;

import java.util.ArrayDeque;
import java.util.Collection;
import java.util.Deque;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Collectors;
import software.amazon.smithy.model.Model;
import software.amazon.smithy.model.shapes.ListShape;
import software.amazon.smithy.model.shapes.MapShape;
import software.amazon.smithy.model.shapes.MemberShape;
import software.amazon.smithy.model.shapes.SetShape;
import software.amazon.smithy.model.shapes.Shape;
import software.amazon.smithy.model.shapes.ShapeIndex;
import software.amazon.smithy.model.shapes.ShapeVisitor;
import software.amazon.smithy.model.shapes.StructureShape;
import software.amazon.smithy.model.shapes.UnionShape;
import software.amazon.smithy.model.transform.ModelTransformer;
import software.amazon.smithy.model.transform.ModelTransformerPlugin;
import software.amazon.smithy.utils.ListUtils;

final class RemoveShapes {
    private final Collection<Shape> toRemove;
    private final List<ModelTransformerPlugin> plugins;

    RemoveShapes(Collection<Shape> toRemove, List<ModelTransformerPlugin> plugins) {
        this.toRemove = toRemove;
        this.plugins = plugins;
    }

    Model transform(ModelTransformer transformer, Model model) {
        HashSet<Shape> removed = new HashSet<Shape>();
        ShapeIndex index = model.getShapeIndex();
        Deque queue = index.shapes().filter(this.toRemove::contains).collect(Collectors.toCollection(ArrayDeque::new));
        ShapeRemovalVisitor removalVisitor = new ShapeRemovalVisitor();
        while (!queue.isEmpty()) {
            Shape shape2 = (Shape)queue.pop();
            if (!removed.contains(shape2)) {
                queue.addAll(shape2.accept(removalVisitor));
            }
            removed.add(shape2);
        }
        ShapeIndex.Builder builder = index.toBuilder();
        removed.forEach(shape -> builder.removeShape(shape.getId()));
        Model result = model.toBuilder().shapeIndex(builder.build()).build();
        for (ModelTransformerPlugin plugin : this.plugins) {
            result = plugin.onRemove(transformer, removed, result);
        }
        return result;
    }

    static final class ShapeRemovalVisitor
    extends ShapeVisitor.Default<Collection<? extends Shape>> {
        ShapeRemovalVisitor() {
        }

        @Override
        public Collection<? extends Shape> getDefault(Shape shape) {
            return ListUtils.of();
        }

        @Override
        public Collection<? extends Shape> listShape(ListShape shape) {
            return ListUtils.of((Object)shape.getMember());
        }

        @Override
        public Collection<? extends Shape> setShape(SetShape shape) {
            return ListUtils.of((Object)shape.getMember());
        }

        @Override
        public Collection<? extends Shape> mapShape(MapShape shape) {
            return ListUtils.of((Object[])new MemberShape[]{shape.getKey(), shape.getValue()});
        }

        @Override
        public Collection<? extends Shape> structureShape(StructureShape shape) {
            return shape.getAllMembers().values();
        }

        @Override
        public Collection<? extends Shape> unionShape(UnionShape shape) {
            return shape.getAllMembers().values();
        }
    }
}

