/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.model.selector;

import java.util.List;
import software.amazon.smithy.model.node.BooleanNode;
import software.amazon.smithy.model.node.Node;
import software.amazon.smithy.model.node.NodeVisitor;
import software.amazon.smithy.model.node.NumberNode;
import software.amazon.smithy.model.node.StringNode;
import software.amazon.smithy.model.node.ToNode;
import software.amazon.smithy.model.selector.AttributeSelector;
import software.amazon.smithy.model.shapes.Shape;
import software.amazon.smithy.utils.ListUtils;

final class TraitAttributeKey
implements AttributeSelector.KeyGetter {
    private static final NodeToString NODE_TO_STRING = new NodeToString();
    private final String trait;

    TraitAttributeKey(String trait) {
        this.trait = trait;
    }

    @Override
    public List<String> apply(Shape shape) {
        return shape.findTrait(this.trait).map(ToNode::toNode).map(node -> ListUtils.of((Object)node.accept(NODE_TO_STRING))).orElse(ListUtils.of());
    }

    private static final class NodeToString
    extends NodeVisitor.Default<String> {
        private NodeToString() {
        }

        @Override
        protected String getDefault(Node node) {
            return "";
        }

        @Override
        public String stringNode(StringNode node) {
            return node.getValue();
        }

        @Override
        public String numberNode(NumberNode node) {
            return node.getValue().toString();
        }

        @Override
        public String booleanNode(BooleanNode node) {
            return Boolean.toString(node.getValue());
        }
    }
}

