/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.model.selector;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import software.amazon.smithy.model.neighbor.NeighborProvider;
import software.amazon.smithy.model.selector.Selector;
import software.amazon.smithy.model.shapes.Shape;
import software.amazon.smithy.utils.SetUtils;

final class TestSelector
implements Selector {
    private final List<Selector> selectors;

    TestSelector(List<Selector> selectors) {
        this.selectors = selectors;
    }

    @Override
    public Set<Shape> select(NeighborProvider neighborProvider, Set<Shape> shapes) {
        HashSet<Shape> result = new HashSet<Shape>();
        block0: for (Shape shape : shapes) {
            Set attempt = SetUtils.of((Object)shape);
            for (Selector predicate : this.selectors) {
                if (predicate.select(neighborProvider, attempt).size() <= 0) continue;
                result.add(shape);
                continue block0;
            }
        }
        return result;
    }
}

