/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.model.selector;

import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.stream.Collectors;
import software.amazon.smithy.model.neighbor.NeighborProvider;
import software.amazon.smithy.model.selector.Selector;
import software.amazon.smithy.model.shapes.ServiceShape;
import software.amazon.smithy.model.shapes.Shape;
import software.amazon.smithy.utils.ListUtils;

final class AttributeSelector
implements Selector {
    static final Comparator EQUALS = String::equals;
    static final Comparator STARTS_WITH = String::startsWith;
    static final Comparator ENDS_WITH = String::endsWith;
    static final Comparator CONTAINS = String::contains;
    static final KeyGetter KEY_ID = shape -> ListUtils.of((Object)shape.getId().toString());
    static final KeyGetter KEY_ID_NAMESPACE = shape -> ListUtils.of((Object)shape.getId().getNamespace());
    static final KeyGetter KEY_ID_NAME = shape -> ListUtils.of((Object)shape.getId().getName());
    static final KeyGetter KEY_ID_MEMBER = shape -> shape.getId().getMember().map(Collections::singletonList).orElseGet(Collections::emptyList);
    static final KeyGetter KEY_SERVICE_VERSION = shape -> shape.asServiceShape().map(ServiceShape::getVersion).map(Collections::singletonList).orElseGet(Collections::emptyList);
    private final KeyGetter key;
    private final String expected;
    private final Comparator comparator;
    private final boolean caseInsensitive;

    AttributeSelector(KeyGetter key) {
        this.key = key;
        this.expected = null;
        this.comparator = null;
        this.caseInsensitive = false;
    }

    AttributeSelector(KeyGetter key, Comparator comparator, String expected, boolean caseInsensitive) {
        this.expected = expected;
        this.key = key;
        this.caseInsensitive = caseInsensitive;
        this.comparator = comparator;
    }

    @Override
    public Set<Shape> select(NeighborProvider neighborProvider, Set<Shape> shapes) {
        return shapes.stream().filter(shape -> this.matchesAttribute((List)this.key.apply(shape))).collect(Collectors.toSet());
    }

    private boolean matchesAttribute(List<String> result) {
        if (this.comparator == null || this.expected == null) {
            return !result.isEmpty();
        }
        String rhs = this.caseInsensitive ? this.expected.toLowerCase(Locale.US) : this.expected;
        return result.stream().map(value -> this.caseInsensitive ? value.toLowerCase(Locale.US) : value).anyMatch(lhs -> (Boolean)this.comparator.apply(lhs, rhs));
    }

    static interface Comparator
    extends BiFunction<String, String, Boolean> {
    }

    static interface KeyGetter
    extends Function<Shape, List<String>> {
    }
}

