/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.model.node;

import com.fasterxml.jackson.core.JsonGenerator;
import java.io.IOException;
import java.math.BigDecimal;
import java.util.Map;
import software.amazon.smithy.model.node.ArrayNode;
import software.amazon.smithy.model.node.BooleanNode;
import software.amazon.smithy.model.node.Node;
import software.amazon.smithy.model.node.NodeVisitor;
import software.amazon.smithy.model.node.NullNode;
import software.amazon.smithy.model.node.NumberNode;
import software.amazon.smithy.model.node.ObjectNode;
import software.amazon.smithy.model.node.StringNode;

final class DefaultNodeWriter
implements NodeVisitor<Void> {
    private JsonGenerator generator;

    DefaultNodeWriter(JsonGenerator generator) {
        this.generator = generator;
    }

    @Override
    public Void arrayNode(ArrayNode node) {
        try {
            this.generator.writeStartArray(node.size());
            node.getElements().forEach(element -> element.accept(this));
            this.generator.writeEndArray();
            return null;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public Void booleanNode(BooleanNode node) {
        try {
            this.generator.writeBoolean(node.getValue());
            return null;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public Void nullNode(NullNode node) {
        try {
            this.generator.writeNull();
            return null;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public Void numberNode(NumberNode node) {
        try {
            if (node.getValue() instanceof BigDecimal) {
                this.generator.writeNumber((BigDecimal)node.getValue());
            } else if (node.isFloatingPointNumber()) {
                this.generator.writeNumber(node.getValue().doubleValue());
            } else {
                this.generator.writeNumber(node.getValue().longValue());
            }
            return null;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public Void objectNode(ObjectNode node) {
        try {
            this.generator.writeStartObject();
            for (Map.Entry<StringNode, Node> entry : node.getMembers().entrySet()) {
                this.generator.writeFieldName(entry.getKey().getValue());
                entry.getValue().accept(this);
            }
            this.generator.writeEndObject();
            return null;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public Void stringNode(StringNode node) {
        try {
            this.generator.writeString(node.getValue());
            return null;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

