/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.model.neighbor;

import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import software.amazon.smithy.model.Model;
import software.amazon.smithy.model.knowledge.NeighborProviderIndex;
import software.amazon.smithy.model.loader.Prelude;
import software.amazon.smithy.model.neighbor.Walker;
import software.amazon.smithy.model.shapes.ServiceShape;
import software.amazon.smithy.model.shapes.Shape;
import software.amazon.smithy.model.shapes.ShapeId;
import software.amazon.smithy.model.shapes.ShapeIndex;
import software.amazon.smithy.utils.FunctionalUtils;
import software.amazon.smithy.utils.OptionalUtils;

public final class UnreferencedTraitDefinitions {
    private final Predicate<Shape> keepFilter;

    public UnreferencedTraitDefinitions() {
        this(traitDefinition -> true);
    }

    public UnreferencedTraitDefinitions(Predicate<Shape> keepFilter) {
        this.keepFilter = keepFilter;
    }

    public Set<Shape> compute(Model model) {
        Walker walker = new Walker(model.getKnowledge(NeighborProviderIndex.class).getProvider());
        ShapeIndex index = model.getShapeIndex();
        Set<Shape> unused = model.getTraitShapes().stream().filter(FunctionalUtils.not(Prelude::isPreludeShape)).collect(Collectors.toSet());
        index.shapes(ServiceShape.class).flatMap(service -> walker.walkShapes((Shape)service).stream()).distinct().map(Shape::getAllTraits).flatMap(traits -> traits.keySet().stream()).distinct().flatMap(traitId -> OptionalUtils.stream(index.getShape((ShapeId)traitId))).filter(this.keepFilter).forEach(unused::remove);
        return unused;
    }
}

