/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.model.validation.validators;

import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import software.amazon.smithy.model.Model;
import software.amazon.smithy.model.shapes.MemberShape;
import software.amazon.smithy.model.shapes.StructureShape;
import software.amazon.smithy.model.traits.HttpQueryTrait;
import software.amazon.smithy.model.traits.Trait;
import software.amazon.smithy.model.validation.AbstractValidator;
import software.amazon.smithy.model.validation.ValidationEvent;
import software.amazon.smithy.model.validation.ValidationUtils;

public final class HttpQueryTraitValidator
extends AbstractValidator {
    @Override
    public List<ValidationEvent> validate(Model model) {
        return model.getShapeIndex().shapes(StructureShape.class).flatMap(shape -> this.validateStructure((StructureShape)shape).stream()).collect(Collectors.toList());
    }

    private List<ValidationEvent> validateStructure(StructureShape structure) {
        return structure.getAllMembers().values().stream().flatMap(member -> Trait.flatMapStream(member, HttpQueryTrait.class)).collect(Collectors.groupingBy(pair -> ((HttpQueryTrait)pair.getRight()).getValue(), Collectors.mapping(pair -> ((MemberShape)pair.getLeft()).getMemberName(), Collectors.toList()))).entrySet().stream().filter(entry -> ((List)entry.getValue()).size() > 1).map(entry -> this.error(structure, String.format("`httpQuery` parameter name binding conflicts found for the `%s` parameter in the following structure members: %s", entry.getKey(), ValidationUtils.tickedList((Collection)entry.getValue())))).collect(Collectors.toList());
    }
}

