/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.model.traits;

import java.util.Objects;
import software.amazon.smithy.model.FromSourceLocation;
import software.amazon.smithy.model.SourceLocation;
import software.amazon.smithy.model.node.Node;
import software.amazon.smithy.model.shapes.ShapeId;
import software.amazon.smithy.model.traits.Trait;
import software.amazon.smithy.model.traits.TraitService;

public abstract class AbstractTrait
implements Trait {
    private final ShapeId traitId;
    private final SourceLocation traitSourceLocation;
    private int cachedHashCode = 0;
    private Node nodeCache;

    public AbstractTrait(ShapeId id, FromSourceLocation sourceLocation) {
        this.traitId = Objects.requireNonNull(id, "id was not set on trait");
        this.traitSourceLocation = Objects.requireNonNull(sourceLocation, "sourceLocation was not set on trait").getSourceLocation();
    }

    @Override
    public final ShapeId toShapeId() {
        return this.traitId;
    }

    @Override
    public final SourceLocation getSourceLocation() {
        return this.traitSourceLocation;
    }

    public String toString() {
        return String.format("Trait `%s`, defined at %s", this.toShapeId(), this.getSourceLocation());
    }

    public boolean equals(Object other) {
        if (!(other instanceof Trait)) {
            return false;
        }
        Trait b = (Trait)other;
        return this == other || this.toShapeId().equals(b.toShapeId()) && this.toNode().equals(b.toNode());
    }

    public int hashCode() {
        if (this.cachedHashCode == 0) {
            this.cachedHashCode = this.toShapeId().hashCode() * 17 + this.toNode().hashCode();
        }
        return this.cachedHashCode;
    }

    @Override
    public final Node toNode() {
        if (this.nodeCache == null) {
            this.nodeCache = this.createNode();
        }
        return this.nodeCache;
    }

    protected abstract Node createNode();

    public static abstract class Provider
    implements TraitService {
        private final ShapeId id;

        public Provider(ShapeId id) {
            this.id = id;
        }

        @Override
        public ShapeId getShapeId() {
            return this.id;
        }
    }
}

