/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.model.selector;

import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import software.amazon.smithy.model.Model;
import software.amazon.smithy.model.SourceException;
import software.amazon.smithy.model.knowledge.NeighborProviderIndex;
import software.amazon.smithy.model.neighbor.NeighborProvider;
import software.amazon.smithy.model.neighbor.Relationship;
import software.amazon.smithy.model.neighbor.RelationshipDirection;
import software.amazon.smithy.model.neighbor.RelationshipType;
import software.amazon.smithy.model.selector.Selector;
import software.amazon.smithy.model.shapes.MemberShape;
import software.amazon.smithy.model.shapes.OperationShape;
import software.amazon.smithy.model.shapes.Shape;
import software.amazon.smithy.model.shapes.ShapeId;
import software.amazon.smithy.model.shapes.ShapeIndex;
import software.amazon.smithy.model.shapes.StructureShape;
import software.amazon.smithy.model.shapes.ToShapeId;
import software.amazon.smithy.utils.ListUtils;

public final class PathFinder {
    private static final Logger LOGGER = Logger.getLogger(PathFinder.class.getName());
    private final ShapeIndex index;
    private final NeighborProvider neighborProvider;
    private final NeighborProvider reverseProvider;

    private PathFinder(ShapeIndex index, NeighborProvider neighborProvider) {
        this.index = index;
        this.neighborProvider = neighborProvider;
        this.reverseProvider = NeighborProvider.reverse(index, neighborProvider);
    }

    public static PathFinder create(Model model) {
        return new PathFinder(model.getShapeIndex(), model.getKnowledge(NeighborProviderIndex.class).getProvider());
    }

    public static PathFinder create(ShapeIndex index) {
        return new PathFinder(index, NeighborProvider.of(index));
    }

    public List<Path> search(ToShapeId startingShape, String targetSelector) {
        return this.search(startingShape, Selector.parse(targetSelector));
    }

    public List<Path> search(ToShapeId startingShape, Selector targetSelector) {
        Shape shape = this.index.getShape(startingShape.toShapeId()).orElse(null);
        if (shape == null) {
            return ListUtils.of();
        }
        Set<Shape> candidates = targetSelector.select(this.neighborProvider, this.index);
        if (candidates.isEmpty()) {
            LOGGER.info(() -> "No shapes matched the PathFinder selector of `" + targetSelector + "`");
            return ListUtils.of();
        }
        LOGGER.finest(() -> candidates.size() + " shapes matched the PathFinder selector of " + targetSelector);
        return new Search(this.reverseProvider, shape, candidates).execute();
    }

    public Optional<Path> createPathToInputMember(ToShapeId operationId, String memberName) {
        return this.createPathTo(operationId, memberName, RelationshipType.INPUT);
    }

    public Optional<Path> createPathToOutputMember(ToShapeId operationId, String memberName) {
        return this.createPathTo(operationId, memberName, RelationshipType.OUTPUT);
    }

    private Optional<Path> createPathTo(ToShapeId operationId, String memberName, RelationshipType rel) {
        OperationShape operation = this.index.getShape(operationId.toShapeId()).flatMap(Shape::asOperationShape).orElse(null);
        if (operation == null) {
            return Optional.empty();
        }
        Optional<ShapeId> structId = rel == RelationshipType.INPUT ? operation.getInput() : operation.getOutput();
        StructureShape struct = structId.flatMap(this.index::getShape).flatMap(Shape::asStructureShape).orElse(null);
        if (struct == null) {
            return Optional.empty();
        }
        MemberShape member = struct.getMember(memberName).orElse(null);
        if (member == null) {
            return Optional.empty();
        }
        Shape target = this.index.getShape(member.getTarget()).orElse(null);
        if (target == null) {
            return Optional.empty();
        }
        ArrayList<Relationship> relationships = new ArrayList<Relationship>();
        relationships.add(Relationship.create(operation, rel, struct));
        relationships.add(Relationship.create(struct, RelationshipType.STRUCTURE_MEMBER, member));
        relationships.add(Relationship.create(member, RelationshipType.MEMBER_TARGET, target));
        return Optional.of(new Path(relationships));
    }

    private static final class Search {
        private final Shape startingShape;
        private final NeighborProvider provider;
        private final Collection<Shape> candidates;
        private final List<Path> results = new ArrayList<Path>();

        Search(NeighborProvider provider, Shape startingShape, Collection<Shape> candidates) {
            this.startingShape = startingShape;
            this.candidates = candidates;
            this.provider = provider;
        }

        List<Path> execute() {
            for (Shape candidate : this.candidates) {
                this.traverseUp(candidate, new LinkedList<Relationship>(), new HashSet<ShapeId>());
            }
            return this.results;
        }

        private void traverseUp(Shape current, List<Relationship> path, Set<ShapeId> visited) {
            if (!path.isEmpty() && current.getId().equals(this.startingShape.getId())) {
                this.results.add(new Path(path));
                return;
            }
            if (visited.contains(current.getId())) {
                return;
            }
            HashSet<ShapeId> newVisited = new HashSet<ShapeId>(visited);
            newVisited.add(current.getId());
            for (Relationship relationship : this.provider.getNeighbors(current)) {
                if (relationship.getDirection() != RelationshipDirection.DIRECTED) continue;
                ArrayList<Relationship> newPath = new ArrayList<Relationship>(path.size() + 1);
                newPath.add(relationship);
                newPath.addAll(path);
                this.traverseUp(relationship.getShape(), newPath, newVisited);
            }
        }
    }

    public static final class Path
    extends AbstractList<Relationship> {
        private List<Relationship> relationships;

        public Path(List<Relationship> relationships) {
            if (relationships.isEmpty()) {
                throw new IllegalArgumentException("Relationships cannot be empty!");
            }
            this.relationships = relationships;
        }

        @Override
        public int size() {
            return this.relationships.size();
        }

        @Override
        public Relationship get(int index) {
            return this.relationships.get(index);
        }

        public List<Shape> getShapes() {
            List<Shape> results = this.relationships.stream().map(Relationship::getShape).collect(Collectors.toList());
            Relationship last = this.relationships.get(this.relationships.size() - 1);
            if (last.getNeighborShape().isPresent()) {
                results.add(last.getNeighborShape().get());
            }
            return results;
        }

        public Shape getStartShape() {
            return this.relationships.get(0).getShape();
        }

        public Shape getEndShape() {
            Relationship last = this.relationships.get(this.relationships.size() - 1);
            return last.getNeighborShape().orElseThrow(() -> new SourceException("Relationship points to a shape that is invalid: " + last, last.getShape()));
        }

        @Override
        public String toString() {
            StringBuilder result = new StringBuilder();
            result.append("[id|").append(this.getStartShape().getId()).append("]");
            for (Relationship rel : this.relationships) {
                if (rel.getRelationshipType() == RelationshipType.MEMBER_TARGET) {
                    result.append(" > ");
                } else {
                    result.append(" -[").append(rel.getRelationshipType().getSelectorLabel().orElseGet(() -> rel.getRelationshipType().toString())).append("]-> ");
                }
                result.append("[id|").append(rel.getNeighborShapeId()).append("]");
            }
            return result.toString();
        }
    }
}

