/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.model.transform;

import java.util.function.Predicate;
import java.util.stream.Collectors;
import software.amazon.smithy.model.Model;
import software.amazon.smithy.model.loader.Prelude;
import software.amazon.smithy.model.shapes.Shape;
import software.amazon.smithy.model.shapes.ShapeIndex;
import software.amazon.smithy.model.transform.ModelTransformer;
import software.amazon.smithy.utils.FunctionalUtils;

final class FilterShapes {
    private final Predicate<Shape> predicate;

    FilterShapes(Predicate<Shape> predicate) {
        this.predicate = predicate.or(shape -> Prelude.isPreludeShape(shape.getId()));
    }

    Model transform(ModelTransformer transformer, Model model) {
        return transformer.removeShapes(model, model.getShapeIndex().shapes().filter(shape -> FilterShapes.canFilterShape(model.getShapeIndex(), shape)).filter(FunctionalUtils.not(this.predicate)).collect(Collectors.toSet()));
    }

    private static boolean canFilterShape(ShapeIndex index, Shape shape) {
        return !shape.isMemberShape() || index.getShape(shape.asMemberShape().get().getContainer()).filter(container -> container.isStructureShape() || container.isUnionShape()).isPresent();
    }
}

