/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.model.shapes;

import java.util.Optional;

public enum ShapeType {
    BLOB("blob"),
    BOOLEAN("boolean"),
    STRING("string"),
    TIMESTAMP("timestamp"),
    BYTE("byte"),
    SHORT("short"),
    INTEGER("integer"),
    LONG("long"),
    FLOAT("float"),
    DOCUMENT("document"),
    DOUBLE("double"),
    BIG_DECIMAL("bigDecimal"),
    BIG_INTEGER("bigInteger"),
    LIST("list"),
    SET("set"),
    MAP("map"),
    STRUCTURE("structure"),
    UNION("union"),
    SERVICE("service"),
    RESOURCE("resource"),
    OPERATION("operation"),
    MEMBER("member");

    private final String stringValue;

    private ShapeType(String stringValue) {
        this.stringValue = stringValue;
    }

    public String toString() {
        return this.stringValue;
    }

    public static Optional<ShapeType> fromString(String text) {
        for (ShapeType e : ShapeType.values()) {
            if (!e.stringValue.equals(text)) continue;
            return Optional.of(e);
        }
        return Optional.empty();
    }
}

