/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.model.shapes;

import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.TreeMap;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.smithy.model.Model;
import software.amazon.smithy.model.SourceLocation;
import software.amazon.smithy.model.loader.Prelude;
import software.amazon.smithy.model.node.ArrayNode;
import software.amazon.smithy.model.node.Node;
import software.amazon.smithy.model.node.ObjectNode;
import software.amazon.smithy.model.node.StringNode;
import software.amazon.smithy.model.node.ToNode;
import software.amazon.smithy.model.shapes.ListShape;
import software.amazon.smithy.model.shapes.MapShape;
import software.amazon.smithy.model.shapes.MemberShape;
import software.amazon.smithy.model.shapes.OperationShape;
import software.amazon.smithy.model.shapes.ResourceShape;
import software.amazon.smithy.model.shapes.ServiceShape;
import software.amazon.smithy.model.shapes.SetShape;
import software.amazon.smithy.model.shapes.Shape;
import software.amazon.smithy.model.shapes.ShapeId;
import software.amazon.smithy.model.shapes.ShapeVisitor;
import software.amazon.smithy.model.shapes.StructureShape;
import software.amazon.smithy.model.shapes.UnionShape;
import software.amazon.smithy.model.traits.Trait;
import software.amazon.smithy.utils.FunctionalUtils;
import software.amazon.smithy.utils.Pair;
import software.amazon.smithy.utils.SmithyBuilder;

public final class ModelSerializer {
    private final Predicate<String> metadataFilter;
    private final Predicate<Shape> shapeFilter;
    private final Predicate<Trait> traitFilter;
    private final ShapeSerializer shapeSerializer = new ShapeSerializer();

    private ModelSerializer(Builder builder) {
        this.metadataFilter = builder.metadataFilter;
        this.shapeFilter = builder.shapeFilter.and(FunctionalUtils.not(Prelude::isPreludeShape));
        this.traitFilter = builder.traitFilter;
    }

    public ObjectNode serialize(Model model) {
        return Node.objectNode().withMember("smithy", Node.from("0.3.0")).withOptionalMember("metadata", this.createMetadata(model).map(Node::withDeepSortedKeys)).merge(this.createNamespaces(model).entrySet().stream().collect(ObjectNode.collectStringKeys(Map.Entry::getKey, entry -> this.createNamespaceNode((List)entry.getValue()))));
    }

    private Optional<Node> createMetadata(Model model) {
        Map<StringNode, Node> metadata = model.getMetadata().entrySet().stream().filter(entry -> this.metadataFilter.test((String)entry.getKey())).collect(Collectors.toMap(entry -> Node.from((String)entry.getKey()), Map.Entry::getValue));
        return metadata.isEmpty() ? Optional.empty() : Optional.of(new ObjectNode(metadata, SourceLocation.NONE));
    }

    private ObjectNode createNamespaceNode(List<Shape> shapes) {
        ObjectNode.Builder builder = Node.objectNodeBuilder();
        if (!shapes.isEmpty()) {
            builder.withMember("shapes", shapes.stream().filter(FunctionalUtils.not(Shape::isMemberShape)).map(shape -> Pair.of((Object)shape, (Object)shape.accept(this.shapeSerializer))).sorted(Comparator.comparing(pair -> ((Shape)pair.getLeft()).getId().getName())).collect(ObjectNode.collectStringKeys(pair -> ((Shape)pair.getLeft()).getId().getName(), Pair::getRight)));
        }
        return builder.build();
    }

    private TreeMap<String, List<Shape>> createNamespaces(Model model) {
        Map<String, List<Shape>> shapes = model.getShapeIndex().shapes().filter(this.shapeFilter).collect(Collectors.groupingBy(s -> s.getId().getNamespace()));
        return shapes.keySet().stream().sorted().collect(Collectors.toMap(Function.identity(), shapes::get, (a, b) -> a, TreeMap::new));
    }

    public static Builder builder() {
        return new Builder();
    }

    private final class ShapeSerializer
    extends ShapeVisitor.Default<Node> {
        private ShapeSerializer() {
        }

        private ObjectNode createTypedNode(Shape shape) {
            return Node.objectNode().withMember("type", Node.from(shape.getType().toString()));
        }

        private ObjectNode withTraits(Shape shape, ObjectNode node) {
            return node.merge(shape.getAllTraits().values().stream().filter(ModelSerializer.this.traitFilter).sorted(Comparator.comparing(Trait::toShapeId)).collect(ObjectNode.collectStringKeys(trait -> trait.toShapeId().toString(), ToNode::toNode)));
        }

        @Override
        protected ObjectNode getDefault(Shape shape) {
            return this.withTraits(shape, this.createTypedNode(shape));
        }

        @Override
        public Node listShape(ListShape shape) {
            return this.withTraits(shape, this.createTypedNode(shape).withMember("member", shape.getMember().accept(this)));
        }

        @Override
        public Node setShape(SetShape shape) {
            return this.withTraits(shape, this.createTypedNode(shape).withMember("member", shape.getMember().accept(this)));
        }

        @Override
        public Node mapShape(MapShape shape) {
            return this.withTraits(shape, this.createTypedNode(shape).withMember("key", shape.getKey().accept(this)).withMember("value", shape.getValue().accept(this)));
        }

        @Override
        public Node operationShape(OperationShape shape) {
            return this.withTraits(shape, this.createTypedNode(shape).withOptionalMember("input", shape.getInput().map(id -> Node.from(id.toString()))).withOptionalMember("output", shape.getOutput().map(id -> Node.from(id.toString()))).withOptionalMember("errors", this.createOptionalIdList(shape.getErrors())));
        }

        @Override
        public Node resourceShape(ResourceShape shape) {
            Optional<Object> identifiers = Optional.empty();
            if (shape.hasIdentifiers()) {
                Stream ids = shape.getIdentifiers().entrySet().stream();
                identifiers = Optional.of((Node)ids.collect(ObjectNode.collectStringKeys(Map.Entry::getKey, entry -> Node.from(((ShapeId)entry.getValue()).toString()))));
            }
            return this.withTraits(shape, this.createTypedNode(shape).withOptionalMember("identifiers", identifiers).withOptionalMember("create", shape.getCreate().map(ShapeId::toString).map(Node::from)).withOptionalMember("read", shape.getRead().map(ShapeId::toString).map(Node::from)).withOptionalMember("update", shape.getUpdate().map(ShapeId::toString).map(Node::from)).withOptionalMember("delete", shape.getDelete().map(ShapeId::toString).map(Node::from)).withOptionalMember("list", shape.getList().map(ShapeId::toString).map(Node::from)).withOptionalMember("operations", this.createOptionalIdList(shape.getOperations())).withOptionalMember("resources", this.createOptionalIdList(shape.getResources())));
        }

        @Override
        public Node serviceShape(ServiceShape shape) {
            return this.withTraits(shape, this.createTypedNode(shape).withMember("version", Node.from(shape.getVersion())).withOptionalMember("operations", this.createOptionalIdList(shape.getOperations())).withOptionalMember("resources", this.createOptionalIdList(shape.getResources())));
        }

        private Optional<Node> createOptionalIdList(Collection<ShapeId> list) {
            if (list.isEmpty()) {
                return Optional.empty();
            }
            return Optional.of((Node)list.stream().map(ShapeId::toString).sorted().map(Node::from).collect(ArrayNode.collect()));
        }

        @Override
        public Node structureShape(StructureShape shape) {
            return this.createStructureAndUnion(shape, shape.getAllMembers());
        }

        @Override
        public Node unionShape(UnionShape shape) {
            return this.createStructureAndUnion(shape, shape.getAllMembers());
        }

        private ObjectNode createStructureAndUnion(Shape shape, Map<String, MemberShape> members) {
            ObjectNode result = this.createTypedNode(shape);
            result = result.withMember("members", members.entrySet().stream().map(entry -> Pair.of((Object)((String)entry.getKey()), (Object)((MemberShape)entry.getValue()).accept(this))).sorted(Comparator.comparing(Pair::getLeft)).collect(ObjectNode.collectStringKeys(Pair::getLeft, Pair::getRight)));
            return this.withTraits(shape, result);
        }

        @Override
        public Node memberShape(MemberShape shape) {
            String target = shape.getContainer().getNamespace().equals(shape.getTarget().getNamespace()) ? shape.getTarget().asRelativeReference() : shape.getTarget().toString();
            return this.withTraits(shape, Node.objectNode().withMember("target", Node.from(target)));
        }
    }

    public static final class Builder
    implements SmithyBuilder<ModelSerializer> {
        private Predicate<String> metadataFilter = pair -> true;
        private Predicate<Shape> shapeFilter = shape -> true;
        private Predicate<Trait> traitFilter = trait -> true;

        private Builder() {
        }

        public Builder metadataFilter(Predicate<String> metadataFilter) {
            this.metadataFilter = Objects.requireNonNull(metadataFilter);
            return this;
        }

        public Builder shapeFilter(Predicate<Shape> shapeFilter) {
            this.shapeFilter = Objects.requireNonNull(shapeFilter);
            return this;
        }

        public Builder traitFilter(Predicate<Trait> traitFilter) {
            this.traitFilter = traitFilter;
            return this;
        }

        public ModelSerializer build() {
            return new ModelSerializer(this);
        }
    }
}

