/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.jmespath;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import software.amazon.smithy.jmespath.ExpressionProblem;
import software.amazon.smithy.jmespath.ExpressionVisitor;
import software.amazon.smithy.jmespath.FunctionDefinition;
import software.amazon.smithy.jmespath.JmespathExpression;
import software.amazon.smithy.jmespath.RuntimeType;
import software.amazon.smithy.jmespath.ast.AndExpression;
import software.amazon.smithy.jmespath.ast.ComparatorExpression;
import software.amazon.smithy.jmespath.ast.ComparatorType;
import software.amazon.smithy.jmespath.ast.CurrentExpression;
import software.amazon.smithy.jmespath.ast.ExpressionTypeExpression;
import software.amazon.smithy.jmespath.ast.FieldExpression;
import software.amazon.smithy.jmespath.ast.FilterProjectionExpression;
import software.amazon.smithy.jmespath.ast.FlattenExpression;
import software.amazon.smithy.jmespath.ast.FunctionExpression;
import software.amazon.smithy.jmespath.ast.IndexExpression;
import software.amazon.smithy.jmespath.ast.LiteralExpression;
import software.amazon.smithy.jmespath.ast.MultiSelectHashExpression;
import software.amazon.smithy.jmespath.ast.MultiSelectListExpression;
import software.amazon.smithy.jmespath.ast.NotExpression;
import software.amazon.smithy.jmespath.ast.ObjectProjectionExpression;
import software.amazon.smithy.jmespath.ast.OrExpression;
import software.amazon.smithy.jmespath.ast.ProjectionExpression;
import software.amazon.smithy.jmespath.ast.SliceExpression;
import software.amazon.smithy.jmespath.ast.Subexpression;

final class TypeChecker
implements ExpressionVisitor<LiteralExpression> {
    private static final Map<String, FunctionDefinition> FUNCTIONS = new HashMap<String, FunctionDefinition>();
    private final LiteralExpression current;
    private final Set<ExpressionProblem> problems;
    private LiteralExpression knownFunctionType = LiteralExpression.ANY;

    TypeChecker(LiteralExpression current, Set<ExpressionProblem> problems) {
        this.current = current;
        this.problems = problems;
    }

    @Override
    public LiteralExpression visitComparator(ComparatorExpression expression) {
        LiteralExpression left = expression.getLeft().accept(this);
        LiteralExpression right = expression.getRight().accept(this);
        LiteralExpression result = left.getType().compare(left, right, expression.getComparator());
        if (result.getType() == RuntimeType.NULL) {
            this.badComparator(expression, left.getType(), expression.getComparator());
        }
        return result;
    }

    @Override
    public LiteralExpression visitCurrentNode(CurrentExpression expression) {
        return this.current;
    }

    @Override
    public LiteralExpression visitExpressionType(ExpressionTypeExpression expression) {
        expression.getExpression().accept(new TypeChecker(this.knownFunctionType, this.problems));
        return LiteralExpression.EXPREF;
    }

    @Override
    public LiteralExpression visitFlatten(FlattenExpression expression) {
        LiteralExpression result = expression.getExpression().accept(this);
        if (!result.isArrayValue()) {
            if (result.getType() != RuntimeType.ANY) {
                this.danger(expression, "Array flatten performed on " + (Object)((Object)result.getType()));
            }
            return LiteralExpression.ARRAY;
        }
        ArrayList<Object> flattened = new ArrayList<Object>();
        for (Object value : result.expectArrayValue()) {
            LiteralExpression element = LiteralExpression.from(value);
            if (element.isArrayValue()) {
                flattened.addAll(element.expectArrayValue());
                continue;
            }
            if (element.isNullValue()) continue;
            flattened.add(element);
        }
        return new LiteralExpression(flattened);
    }

    @Override
    public LiteralExpression visitField(FieldExpression expression) {
        if (this.current.isObjectValue()) {
            if (this.current.hasObjectField(expression.getName())) {
                return this.current.getObjectField(expression.getName());
            }
            this.danger(expression, String.format("Object field '%s' does not exist in object with properties %s", expression.getName(), this.current.expectObjectValue().keySet()));
            return LiteralExpression.NULL;
        }
        if (this.current.getType() != RuntimeType.ANY) {
            this.danger(expression, String.format("Object field '%s' extraction performed on %s", new Object[]{expression.getName(), this.current.getType()}));
        }
        return LiteralExpression.ANY;
    }

    @Override
    public LiteralExpression visitIndex(IndexExpression expression) {
        if (this.current.isArrayValue()) {
            return this.current.getArrayIndex(expression.getIndex());
        }
        if (this.current.getType() != RuntimeType.ANY) {
            this.danger(expression, String.format("Array index '%s' extraction performed on %s", new Object[]{expression.getIndex(), this.current.getType()}));
        }
        return LiteralExpression.ANY;
    }

    @Override
    public LiteralExpression visitLiteral(LiteralExpression expression) {
        return expression;
    }

    @Override
    public LiteralExpression visitMultiSelectList(MultiSelectListExpression expression) {
        ArrayList<Object> values = new ArrayList<Object>();
        for (JmespathExpression e : expression.getExpressions()) {
            values.add(e.accept(this).getValue());
        }
        return new LiteralExpression(values);
    }

    @Override
    public LiteralExpression visitMultiSelectHash(MultiSelectHashExpression expression) {
        LinkedHashMap<String, Object> result = new LinkedHashMap<String, Object>();
        for (Map.Entry<String, JmespathExpression> entry : expression.getExpressions().entrySet()) {
            result.put(entry.getKey(), entry.getValue().accept(this).getValue());
        }
        return new LiteralExpression(result);
    }

    @Override
    public LiteralExpression visitAnd(AndExpression expression) {
        LiteralExpression leftResult = expression.getLeft().accept(this);
        TypeChecker checker = new TypeChecker(leftResult, this.problems);
        LiteralExpression rightResult = expression.getRight().accept(checker);
        if (leftResult.isTruthy() && rightResult.isTruthy()) {
            return rightResult;
        }
        return LiteralExpression.NULL;
    }

    @Override
    public LiteralExpression visitOr(OrExpression expression) {
        LiteralExpression leftResult = expression.getLeft().accept(this);
        LiteralExpression rightResult = expression.getRight().accept(this);
        return leftResult.isTruthy() ? leftResult : rightResult;
    }

    @Override
    public LiteralExpression visitNot(NotExpression expression) {
        LiteralExpression result = expression.getExpression().accept(this);
        return new LiteralExpression(!result.isTruthy());
    }

    @Override
    public LiteralExpression visitProjection(ProjectionExpression expression) {
        LiteralExpression leftResult = expression.getLeft().accept(this);
        if (!leftResult.isArrayValue() || leftResult.expectArrayValue().isEmpty()) {
            if (leftResult.getType() != RuntimeType.ANY && !leftResult.isArrayValue()) {
                this.danger(expression, "Array projection performed on " + (Object)((Object)leftResult.getType()));
            }
            expression.getRight().accept(new TypeChecker(LiteralExpression.ANY, this.problems));
            return LiteralExpression.ARRAY;
        }
        ArrayList<Object> result = new ArrayList<Object>();
        for (Object value : leftResult.expectArrayValue()) {
            TypeChecker checker = new TypeChecker(LiteralExpression.from(value), this.problems);
            result.add(expression.getRight().accept(checker).getValue());
        }
        return new LiteralExpression(result);
    }

    @Override
    public LiteralExpression visitObjectProjection(ObjectProjectionExpression expression) {
        LiteralExpression leftResult = expression.getLeft().accept(this);
        if (!leftResult.isObjectValue()) {
            if (leftResult.getType() != RuntimeType.ANY) {
                this.danger(expression, "Object projection performed on " + (Object)((Object)leftResult.getType()));
            }
            TypeChecker checker = new TypeChecker(LiteralExpression.ANY, this.problems);
            expression.getRight().accept(checker);
            return LiteralExpression.OBJECT;
        }
        ArrayList<Object> result = new ArrayList<Object>();
        for (Object value : leftResult.expectObjectValue().values()) {
            TypeChecker checker = new TypeChecker(LiteralExpression.from(value), this.problems);
            result.add(expression.getRight().accept(checker).getValue());
        }
        return new LiteralExpression(result);
    }

    @Override
    public LiteralExpression visitFilterProjection(FilterProjectionExpression expression) {
        LiteralExpression leftResult = expression.getLeft().accept(this);
        if (!leftResult.isArrayValue() || leftResult.expectArrayValue().isEmpty()) {
            if (!leftResult.isArrayValue() && leftResult.getType() != RuntimeType.ANY) {
                this.danger(expression, "Filter projection performed on " + (Object)((Object)leftResult.getType()));
            }
            TypeChecker rightVisitor = new TypeChecker(LiteralExpression.ANY, this.problems);
            expression.getComparison().accept(rightVisitor);
            expression.getRight().accept(rightVisitor);
            return LiteralExpression.ARRAY;
        }
        ArrayList<Object> result = new ArrayList<Object>();
        for (Object value : leftResult.expectArrayValue()) {
            LiteralExpression rightValue;
            LiteralExpression literalValue = LiteralExpression.from(value);
            TypeChecker rightVisitor = new TypeChecker(literalValue, this.problems);
            LiteralExpression comparisonValue = expression.getComparison().accept(rightVisitor);
            if (!comparisonValue.isTruthy() || (rightValue = expression.getRight().accept(rightVisitor)).isNullValue()) continue;
            result.add(rightValue.getValue());
        }
        return new LiteralExpression(result);
    }

    @Override
    public LiteralExpression visitSlice(SliceExpression expression) {
        if (this.current.isArrayValue()) {
            return this.current;
        }
        if (this.current.getType() != RuntimeType.ANY) {
            this.danger(expression, "Slice performed on " + (Object)((Object)this.current.getType()));
        }
        return LiteralExpression.ARRAY;
    }

    @Override
    public LiteralExpression visitSubexpression(Subexpression expression) {
        LiteralExpression leftResult = expression.getLeft().accept(this);
        TypeChecker rightVisitor = new TypeChecker(leftResult, this.problems);
        return expression.getRight().accept(rightVisitor);
    }

    @Override
    public LiteralExpression visitFunction(FunctionExpression expression) {
        ArrayList<LiteralExpression> arguments = new ArrayList<LiteralExpression>();
        TypeChecker checker = new TypeChecker(this.current, this.problems);
        checker.knownFunctionType = this.current;
        for (JmespathExpression arg : expression.getArguments()) {
            arguments.add(arg.accept(checker));
        }
        FunctionDefinition def = FUNCTIONS.get(expression.getName());
        if (def == null) {
            this.err(expression, "Unknown function: " + expression.getName());
            return LiteralExpression.ANY;
        }
        if (arguments.size() < def.arguments.size() || def.variadic == null && arguments.size() > def.arguments.size()) {
            this.err(expression, expression.getName() + " function expected " + def.arguments.size() + " arguments, but was given " + arguments.size());
        } else {
            for (int i = 0; i < arguments.size(); ++i) {
                String error = null;
                if (def.arguments.size() > i) {
                    error = def.arguments.get(i).validate((LiteralExpression)arguments.get(i));
                } else if (def.variadic != null) {
                    error = def.variadic.validate((LiteralExpression)arguments.get(i));
                }
                if (error == null) continue;
                this.err(expression.getArguments().get(i), expression.getName() + " function argument " + i + " error: " + error);
            }
        }
        return def.returnValue;
    }

    private void err(JmespathExpression e, String message) {
        this.problems.add(new ExpressionProblem(ExpressionProblem.Severity.ERROR, e.getLine(), e.getColumn(), message));
    }

    private void danger(JmespathExpression e, String message) {
        this.problems.add(new ExpressionProblem(ExpressionProblem.Severity.DANGER, e.getLine(), e.getColumn(), message));
    }

    private void warn(JmespathExpression e, String message) {
        this.problems.add(new ExpressionProblem(ExpressionProblem.Severity.WARNING, e.getLine(), e.getColumn(), message));
    }

    private void badComparator(JmespathExpression expression, RuntimeType type, ComparatorType comparatorType) {
        this.warn(expression, "Invalid comparator '" + (Object)((Object)comparatorType) + "' for " + (Object)((Object)type));
    }

    static {
        FunctionDefinition.ArgValidator isAny = FunctionDefinition.isType(RuntimeType.ANY);
        FunctionDefinition.ArgValidator isString = FunctionDefinition.isType(RuntimeType.STRING);
        FunctionDefinition.ArgValidator isNumber = FunctionDefinition.isType(RuntimeType.NUMBER);
        FunctionDefinition.ArgValidator isArray = FunctionDefinition.isType(RuntimeType.ARRAY);
        FUNCTIONS.put("abs", new FunctionDefinition(LiteralExpression.NUMBER, isNumber));
        FUNCTIONS.put("avg", new FunctionDefinition(LiteralExpression.NUMBER, FunctionDefinition.listOfType(RuntimeType.NUMBER)));
        FUNCTIONS.put("contains", new FunctionDefinition(LiteralExpression.BOOLEAN, FunctionDefinition.oneOf(RuntimeType.ARRAY, RuntimeType.STRING), isAny));
        FUNCTIONS.put("ceil", new FunctionDefinition(LiteralExpression.NUMBER, isNumber));
        FUNCTIONS.put("ends_with", new FunctionDefinition(LiteralExpression.NUMBER, isString, isString));
        FUNCTIONS.put("floor", new FunctionDefinition(LiteralExpression.NUMBER, isNumber));
        FUNCTIONS.put("join", new FunctionDefinition(LiteralExpression.STRING, isString, FunctionDefinition.listOfType(RuntimeType.STRING)));
        FUNCTIONS.put("keys", new FunctionDefinition(LiteralExpression.ARRAY, FunctionDefinition.isType(RuntimeType.OBJECT)));
        FUNCTIONS.put("length", new FunctionDefinition(LiteralExpression.NUMBER, FunctionDefinition.oneOf(RuntimeType.STRING, RuntimeType.ARRAY, RuntimeType.OBJECT)));
        FUNCTIONS.put("map", new FunctionDefinition(LiteralExpression.ARRAY, FunctionDefinition.isType(RuntimeType.EXPRESSION), isArray));
        FUNCTIONS.put("max", new FunctionDefinition(LiteralExpression.NUMBER, isArray));
        FUNCTIONS.put("max_by", new FunctionDefinition(LiteralExpression.NUMBER, isArray, FunctionDefinition.isType(RuntimeType.EXPRESSION)));
        FUNCTIONS.put("merge", new FunctionDefinition(LiteralExpression.OBJECT, Collections.emptyList(), FunctionDefinition.isType(RuntimeType.OBJECT)));
        FUNCTIONS.put("min", new FunctionDefinition(LiteralExpression.NUMBER, isArray));
        FUNCTIONS.put("min_by", new FunctionDefinition(LiteralExpression.NUMBER, isArray, FunctionDefinition.isType(RuntimeType.EXPRESSION)));
        FUNCTIONS.put("not_null", new FunctionDefinition(LiteralExpression.ANY, Collections.singletonList(isAny), isAny));
        FUNCTIONS.put("reverse", new FunctionDefinition(LiteralExpression.ARRAY, FunctionDefinition.oneOf(RuntimeType.ARRAY, RuntimeType.STRING)));
        FUNCTIONS.put("sort", new FunctionDefinition(LiteralExpression.ARRAY, isArray));
        FUNCTIONS.put("sort_by", new FunctionDefinition(LiteralExpression.ARRAY, isArray, FunctionDefinition.isType(RuntimeType.EXPRESSION)));
        FUNCTIONS.put("starts_with", new FunctionDefinition(LiteralExpression.BOOLEAN, isString, isString));
        FUNCTIONS.put("sum", new FunctionDefinition(LiteralExpression.NUMBER, FunctionDefinition.listOfType(RuntimeType.NUMBER)));
        FUNCTIONS.put("to_array", new FunctionDefinition(LiteralExpression.ARRAY, isAny));
        FUNCTIONS.put("to_string", new FunctionDefinition(LiteralExpression.STRING, isAny));
        FUNCTIONS.put("to_number", new FunctionDefinition(LiteralExpression.NUMBER, isAny));
        FUNCTIONS.put("type", new FunctionDefinition(LiteralExpression.STRING, isAny));
        FUNCTIONS.put("values", new FunctionDefinition(LiteralExpression.ARRAY, FunctionDefinition.isType(RuntimeType.OBJECT)));
    }
}

