/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.jmespath.ast;

import java.util.Collections;
import java.util.List;
import java.util.Objects;
import software.amazon.smithy.jmespath.ExpressionVisitor;
import software.amazon.smithy.jmespath.JmespathExpression;

public final class MultiSelectListExpression
extends JmespathExpression {
    private final List<JmespathExpression> expressions;

    public MultiSelectListExpression(List<JmespathExpression> expressions) {
        this(expressions, 1, 1);
    }

    public MultiSelectListExpression(List<JmespathExpression> expressions, int line, int column) {
        super(line, column);
        this.expressions = Collections.unmodifiableList(expressions);
    }

    @Override
    public <T> T accept(ExpressionVisitor<T> visitor) {
        return visitor.visitMultiSelectList(this);
    }

    public List<JmespathExpression> getExpressions() {
        return this.expressions;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof MultiSelectListExpression)) {
            return false;
        }
        MultiSelectListExpression that = (MultiSelectListExpression)o;
        return this.expressions.equals(that.expressions);
    }

    public int hashCode() {
        return Objects.hash(this.expressions);
    }

    public String toString() {
        return "MultiSelectListExpression{expressions=" + this.expressions + '}';
    }
}

