/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.jmespath.ast;

import java.util.List;
import java.util.Objects;
import software.amazon.smithy.jmespath.ExpressionVisitor;
import software.amazon.smithy.jmespath.JmespathExpression;

public final class FunctionExpression
extends JmespathExpression {
    public String name;
    public List<JmespathExpression> arguments;

    public FunctionExpression(String name, List<JmespathExpression> arguments) {
        this(name, arguments, 1, 1);
    }

    public FunctionExpression(String name, List<JmespathExpression> arguments, int line, int column) {
        super(line, column);
        this.name = name;
        this.arguments = arguments;
    }

    @Override
    public <T> T accept(ExpressionVisitor<T> visitor) {
        return visitor.visitFunction(this);
    }

    public String getName() {
        return this.name;
    }

    public List<JmespathExpression> getArguments() {
        return this.arguments;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FunctionExpression that = (FunctionExpression)o;
        return this.getName().equals(that.getName()) && this.getArguments().equals(that.getArguments());
    }

    public int hashCode() {
        return Objects.hash(this.getName(), this.getArguments());
    }

    public String toString() {
        return "FunctionExpression{name='" + this.name + '\'' + ", arguments=" + this.arguments + '}';
    }
}

