/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.jmespath;

import java.util.TreeSet;
import software.amazon.smithy.jmespath.ExpressionProblem;
import software.amazon.smithy.jmespath.ExpressionVisitor;
import software.amazon.smithy.jmespath.LinterResult;
import software.amazon.smithy.jmespath.Parser;
import software.amazon.smithy.jmespath.TypeChecker;
import software.amazon.smithy.jmespath.ast.LiteralExpression;

public abstract class JmespathExpression {
    private final int line;
    private final int column;

    protected JmespathExpression(int line, int column) {
        this.line = line;
        this.column = column;
    }

    public static JmespathExpression parse(String text) {
        return Parser.parse(text);
    }

    public final int getLine() {
        return this.line;
    }

    public final int getColumn() {
        return this.column;
    }

    public abstract <T> T accept(ExpressionVisitor<T> var1);

    public LinterResult lint() {
        return this.lint(LiteralExpression.ANY);
    }

    public LinterResult lint(LiteralExpression currentNode) {
        TreeSet<ExpressionProblem> problems = new TreeSet<ExpressionProblem>();
        TypeChecker typeChecker = new TypeChecker(currentNode, problems);
        LiteralExpression result = this.accept(typeChecker);
        return new LinterResult(result.getType(), problems);
    }
}

