/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.jmespath;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;
import software.amazon.smithy.jmespath.JmespathException;
import software.amazon.smithy.jmespath.Token;
import software.amazon.smithy.jmespath.TokenIterator;
import software.amazon.smithy.jmespath.TokenType;
import software.amazon.smithy.jmespath.ast.LiteralExpression;

final class Lexer {
    private static final int MAX_NESTING_LEVEL = 50;
    private final String expression;
    private final int length;
    private int position = 0;
    private int line = 1;
    private int column = 1;
    private int nestingLevel = 0;
    private final List<Token> tokens = new ArrayList<Token>();
    private boolean currentlyParsingLiteral;

    private Lexer(String expression) {
        this.expression = Objects.requireNonNull(expression, "expression must not be null");
        this.length = expression.length();
    }

    static TokenIterator tokenize(String expression) {
        return new Lexer(expression).doTokenize();
    }

    TokenIterator doTokenize() {
        block23: while (!this.eof()) {
            char c = this.peek();
            if (c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z' || c == '_') {
                this.tokens.add(this.parseIdentifier());
                continue;
            }
            if (c == '-' || c >= '0' && c <= '9') {
                this.tokens.add(this.parseNumber());
                continue;
            }
            switch (c) {
                case '.': {
                    this.tokens.add(new Token(TokenType.DOT, null, this.line, this.column));
                    this.skip();
                    continue block23;
                }
                case '[': {
                    this.tokens.add(this.parseLbracket());
                    continue block23;
                }
                case '*': {
                    this.tokens.add(new Token(TokenType.STAR, null, this.line, this.column));
                    this.skip();
                    continue block23;
                }
                case '|': {
                    this.tokens.add(this.parseAlternatives('|', TokenType.OR, TokenType.PIPE));
                    continue block23;
                }
                case '@': {
                    this.tokens.add(new Token(TokenType.CURRENT, null, this.line, this.column));
                    this.skip();
                    continue block23;
                }
                case ']': {
                    this.tokens.add(new Token(TokenType.RBRACKET, null, this.line, this.column));
                    this.skip();
                    continue block23;
                }
                case '{': {
                    this.tokens.add(new Token(TokenType.LBRACE, null, this.line, this.column));
                    this.skip();
                    continue block23;
                }
                case '}': {
                    this.tokens.add(new Token(TokenType.RBRACE, null, this.line, this.column));
                    this.skip();
                    continue block23;
                }
                case '&': {
                    this.tokens.add(this.parseAlternatives('&', TokenType.AND, TokenType.EXPREF));
                    continue block23;
                }
                case '(': {
                    this.tokens.add(new Token(TokenType.LPAREN, null, this.line, this.column));
                    this.skip();
                    continue block23;
                }
                case ')': {
                    this.tokens.add(new Token(TokenType.RPAREN, null, this.line, this.column));
                    this.skip();
                    continue block23;
                }
                case ',': {
                    this.tokens.add(new Token(TokenType.COMMA, null, this.line, this.column));
                    this.skip();
                    continue block23;
                }
                case ':': {
                    this.tokens.add(new Token(TokenType.COLON, null, this.line, this.column));
                    this.skip();
                    continue block23;
                }
                case '\"': {
                    this.tokens.add(this.parseString());
                    continue block23;
                }
                case '\'': {
                    this.tokens.add(this.parseRawStringLiteral());
                    continue block23;
                }
                case '`': {
                    this.tokens.add(this.parseLiteral());
                    continue block23;
                }
                case '=': {
                    this.tokens.add(this.parseEquals());
                    continue block23;
                }
                case '>': {
                    this.tokens.add(this.parseAlternatives('=', TokenType.GREATER_THAN_EQUAL, TokenType.GREATER_THAN));
                    continue block23;
                }
                case '<': {
                    this.tokens.add(this.parseAlternatives('=', TokenType.LESS_THAN_EQUAL, TokenType.LESS_THAN));
                    continue block23;
                }
                case '!': {
                    this.tokens.add(this.parseAlternatives('=', TokenType.NOT_EQUAL, TokenType.NOT));
                    continue block23;
                }
                case '\t': 
                case '\n': 
                case '\r': 
                case ' ': {
                    this.skip();
                    continue block23;
                }
            }
            throw this.syntax("Unexpected syntax: " + this.peekSingleCharForMessage());
        }
        this.tokens.add(new Token(TokenType.EOF, null, this.line, this.column));
        return new TokenIterator(this.tokens);
    }

    private boolean eof() {
        return this.position >= this.length;
    }

    private char peek() {
        return this.peek(0);
    }

    private char peek(int offset) {
        int target = this.position + offset;
        if (target >= this.length || target < 0) {
            return '\u0000';
        }
        return this.expression.charAt(target);
    }

    private char expect(char token) {
        if (this.peek() == token) {
            this.skip();
            return token;
        }
        throw this.syntax(String.format("Expected: '%s', but found '%s'", Character.valueOf(token), this.peekSingleCharForMessage()));
    }

    private String peekSingleCharForMessage() {
        char peek = this.peek();
        return peek == '\u0000' ? "[EOF]" : String.valueOf(peek);
    }

    private char expect(char ... tokens) {
        for (char token : tokens) {
            if (this.peek() != token) continue;
            this.skip();
            return token;
        }
        StringBuilder message = new StringBuilder("Found '").append(this.peekSingleCharForMessage()).append("', but expected one of the following tokens:");
        for (char c : tokens) {
            message.append(' ').append('\'').append(c).append('\'');
        }
        throw this.syntax(message.toString());
    }

    private JmespathException syntax(String message) {
        return new JmespathException("Syntax error at line " + this.line + " column " + this.column + ": " + message);
    }

    private void skip() {
        if (this.eof()) {
            return;
        }
        switch (this.expression.charAt(this.position)) {
            case '\r': {
                if (this.peek(1) == '\n') {
                    ++this.position;
                }
                ++this.line;
                this.column = 1;
                break;
            }
            case '\n': {
                ++this.line;
                this.column = 1;
                break;
            }
            default: {
                ++this.column;
            }
        }
        ++this.position;
    }

    private String sliceFrom(int start) {
        return this.expression.substring(start, this.position);
    }

    private int consumeUntilNoLongerMatches(Predicate<Character> predicate) {
        char peekedChar;
        int startPosition = this.position;
        while (!this.eof() && predicate.test(Character.valueOf(peekedChar = this.peek()))) {
            this.skip();
        }
        return this.position - startPosition;
    }

    private void increaseNestingLevel() {
        ++this.nestingLevel;
        if (this.nestingLevel > 50) {
            throw this.syntax("Parser exceeded the maximum allowed depth of 50");
        }
    }

    private void decreaseNestingLevel() {
        --this.nestingLevel;
    }

    private Token parseAlternatives(char next, TokenType first, TokenType second) {
        int currentLine = this.line;
        int currentColumn = this.column;
        this.skip();
        if (this.peek() == next) {
            this.skip();
            return new Token(first, null, currentLine, currentColumn);
        }
        return new Token(second, null, currentLine, currentColumn);
    }

    private Token parseEquals() {
        int currentLine = this.line;
        int currentColumn = this.column;
        this.skip();
        this.expect('=');
        return new Token(TokenType.EQUAL, null, currentLine, currentColumn);
    }

    private Token parseIdentifier() {
        int start = this.position;
        int currentLine = this.line;
        int currentColumn = this.column;
        this.consumeUntilNoLongerMatches(this::isIdentifierCharacter);
        LiteralExpression literalNode = new LiteralExpression(this.sliceFrom(start), currentLine, currentColumn);
        return new Token(TokenType.IDENTIFIER, literalNode, currentLine, currentColumn);
    }

    private boolean isIdentifierCharacter(char c) {
        return c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z' || c == '_' || c >= '0' && c <= '9';
    }

    private Token parseString() {
        int currentLine = this.line;
        int currentColumn = this.column;
        this.expect('\"');
        String value = this.consumeInsideString();
        return new Token(TokenType.IDENTIFIER, new LiteralExpression(value, currentLine, currentColumn), currentLine, currentColumn);
    }

    private String consumeInsideString() {
        StringBuilder builder = new StringBuilder();
        block17: while (!this.eof()) {
            switch (this.peek()) {
                case '\"': {
                    this.skip();
                    return builder.toString();
                }
                case '\\': {
                    this.skip();
                    switch (this.peek()) {
                        case '\"': {
                            builder.append('\"');
                            this.skip();
                            continue block17;
                        }
                        case 'n': {
                            builder.append('\n');
                            this.skip();
                            continue block17;
                        }
                        case 't': {
                            builder.append('\t');
                            this.skip();
                            continue block17;
                        }
                        case 'r': {
                            builder.append('\r');
                            this.skip();
                            continue block17;
                        }
                        case 'f': {
                            builder.append('\f');
                            this.skip();
                            continue block17;
                        }
                        case 'b': {
                            builder.append('\b');
                            this.skip();
                            continue block17;
                        }
                        case '/': {
                            builder.append('/');
                            this.skip();
                            continue block17;
                        }
                        case '\\': {
                            builder.append('\\');
                            this.skip();
                            continue block17;
                        }
                        case 'u': {
                            this.skip();
                            int unicode = 0;
                            for (int i = 0; i < 4; ++i) {
                                char c = this.peek();
                                this.skip();
                                if (c >= '0' && c <= '9') {
                                    unicode = unicode << 4 | c - 48;
                                    continue;
                                }
                                if (c >= 'a' && c <= 'f') {
                                    unicode = unicode << 4 | 10 + c - 97;
                                    continue;
                                }
                                if (c >= 'A' && c <= 'F') {
                                    unicode = unicode << 4 | 10 + c - 65;
                                    continue;
                                }
                                throw this.syntax("Invalid unicode escape character: `" + c + "`");
                            }
                            builder.append((char)unicode);
                            continue block17;
                        }
                        case '`': {
                            if (!this.currentlyParsingLiteral) break;
                            builder.append('`');
                            this.skip();
                            continue block17;
                        }
                    }
                    throw this.syntax("Invalid escape: " + this.peek());
                }
                case '`': {
                    if (this.currentlyParsingLiteral) {
                        this.skip();
                        break block17;
                    }
                }
                default: {
                    builder.append(this.peek());
                    this.skip();
                    continue block17;
                }
            }
        }
        throw this.syntax("Unclosed quotes");
    }

    private Token parseRawStringLiteral() {
        int currentLine = this.line;
        int currentColumn = this.column;
        this.expect('\'');
        StringBuilder builder = new StringBuilder();
        while (!this.eof()) {
            if (this.peek() == '\\') {
                this.skip();
                if (this.peek() == '\'') {
                    this.skip();
                    builder.append('\'');
                    continue;
                }
                if (this.peek() == '\\') {
                    this.skip();
                }
                builder.append('\\');
                continue;
            }
            if (this.peek() == '\'') {
                this.skip();
                String result = builder.toString();
                return new Token(TokenType.LITERAL, new LiteralExpression(result, currentLine, currentColumn), currentLine, currentColumn);
            }
            builder.append(this.peek());
            this.skip();
        }
        throw this.syntax("Unclosed raw string: " + builder);
    }

    private static boolean isDigit(char c) {
        return c >= '0' && c <= '9';
    }

    private Token parseNumber() {
        int start = this.position;
        int currentLine = this.line;
        int currentColumn = this.column;
        int startPosition = this.position;
        char current = this.peek();
        if (current == '-') {
            this.skip();
            if (!Lexer.isDigit(this.peek())) {
                throw this.syntax(this.createInvalidNumberString(startPosition, "'-' must be followed by a digit"));
            }
        }
        this.consumeUntilNoLongerMatches(Lexer::isDigit);
        char peek = this.peek();
        if (peek == '.') {
            this.skip();
            if (this.consumeUntilNoLongerMatches(Lexer::isDigit) == 0) {
                throw this.syntax(this.createInvalidNumberString(startPosition, "'.' must be followed by a digit"));
            }
        }
        if ((peek = this.peek()) == 'e' || peek == 'E') {
            this.skip();
            peek = this.peek();
            if (peek == '+' || peek == '-') {
                this.skip();
            }
            if (this.consumeUntilNoLongerMatches(Lexer::isDigit) == 0) {
                throw this.syntax(this.createInvalidNumberString(startPosition, "'e', '+', and '-' must be followed by a digit"));
            }
        }
        String lexeme = this.sliceFrom(start);
        try {
            double number = Double.parseDouble(lexeme);
            LiteralExpression node = new LiteralExpression(number, currentLine, currentColumn);
            return new Token(TokenType.NUMBER, node, currentLine, currentColumn);
        }
        catch (NumberFormatException e) {
            throw this.syntax("Invalid number syntax: " + lexeme);
        }
    }

    private String createInvalidNumberString(int startPosition, String message) {
        String lexeme = this.sliceFrom(startPosition);
        return String.format("Invalid number '%s': %s", lexeme, message);
    }

    private Token parseLbracket() {
        int currentLine = this.line;
        int currentColumn = this.column;
        this.skip();
        switch (this.peek()) {
            case ']': {
                this.skip();
                return new Token(TokenType.FLATTEN, null, currentLine, currentColumn);
            }
            case '?': {
                this.skip();
                return new Token(TokenType.FILTER, null, currentLine, currentColumn);
            }
        }
        return new Token(TokenType.LBRACKET, null, currentLine, currentColumn);
    }

    private Token parseLiteral() {
        int currentLine = this.line;
        int currentColumn = this.column;
        this.currentlyParsingLiteral = true;
        this.expect('`');
        this.ws();
        Object value = this.parseJsonValue();
        this.ws();
        this.expect('`');
        this.currentlyParsingLiteral = false;
        LiteralExpression expression = new LiteralExpression(value, currentLine, currentColumn);
        return new Token(TokenType.LITERAL, expression, currentLine, currentColumn);
    }

    private Object parseJsonValue() {
        this.ws();
        switch (this.expect('\"', '{', '[', 't', 'f', 'n', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '-')) {
            case 't': {
                this.expect('r');
                this.expect('u');
                this.expect('e');
                return true;
            }
            case 'f': {
                this.expect('a');
                this.expect('l');
                this.expect('s');
                this.expect('e');
                return false;
            }
            case 'n': {
                this.expect('u');
                this.expect('l');
                this.expect('l');
                return null;
            }
            case '\"': {
                --this.position;
                --this.column;
                return this.parseString().value.expectStringValue();
            }
            case '{': {
                return this.parseJsonObject();
            }
            case '[': {
                return this.parseJsonArray();
            }
        }
        --this.position;
        --this.column;
        return this.parseNumber().value.expectNumberValue();
    }

    private Object parseJsonArray() {
        this.increaseNestingLevel();
        ArrayList<Object> values = new ArrayList<Object>();
        this.ws();
        if (this.peek() == ']') {
            this.skip();
            this.decreaseNestingLevel();
            return values;
        }
        while (!this.eof() && this.peek() != '`') {
            values.add(this.parseJsonValue());
            this.ws();
            if (this.expect(',', ']') == ',') {
                this.ws();
                continue;
            }
            this.decreaseNestingLevel();
            return values;
        }
        throw this.syntax("Unclosed JSON array");
    }

    private Object parseJsonObject() {
        this.increaseNestingLevel();
        LinkedHashMap<String, Object> values = new LinkedHashMap<String, Object>();
        this.ws();
        if (this.peek() == '}') {
            this.skip();
            this.decreaseNestingLevel();
            return values;
        }
        while (!this.eof() && this.peek() != '`') {
            String key = this.parseString().value.expectStringValue();
            this.ws();
            this.expect(':');
            this.ws();
            values.put(key, this.parseJsonValue());
            this.ws();
            if (this.expect(',', '}') == ',') {
                this.ws();
                continue;
            }
            this.decreaseNestingLevel();
            return values;
        }
        throw this.syntax("Unclosed JSON object");
    }

    private void ws() {
        block3: while (!this.eof()) {
            switch (this.peek()) {
                case '\t': 
                case '\n': 
                case '\r': 
                case ' ': {
                    this.skip();
                    continue block3;
                }
            }
            return;
        }
    }
}

