/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.jmespath.ast;

import java.util.Objects;
import java.util.OptionalInt;
import software.amazon.smithy.jmespath.ExpressionVisitor;
import software.amazon.smithy.jmespath.JmespathExpression;

public final class SliceExpression
extends JmespathExpression {
    private final Integer start;
    private final Integer stop;
    private final int step;

    public SliceExpression(Integer start, Integer stop, int step) {
        this(start, stop, step, 1, 1);
    }

    public SliceExpression(Integer start, Integer stop, int step, int line, int column) {
        super(line, column);
        this.start = start;
        this.stop = stop;
        this.step = step;
    }

    @Override
    public <T> T accept(ExpressionVisitor<T> visitor) {
        return visitor.visitSlice(this);
    }

    public OptionalInt getStart() {
        return this.start == null ? OptionalInt.empty() : OptionalInt.of(this.start);
    }

    public OptionalInt getStop() {
        return this.stop == null ? OptionalInt.empty() : OptionalInt.of(this.stop);
    }

    public int getStep() {
        return this.step;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof SliceExpression)) {
            return false;
        }
        SliceExpression sliceNode = (SliceExpression)o;
        return Objects.equals(this.getStart(), sliceNode.getStart()) && Objects.equals(this.getStop(), sliceNode.getStop()) && this.getStep() == sliceNode.getStep();
    }

    public int hashCode() {
        return Objects.hash(this.getStart(), this.getStop(), this.getStep());
    }

    public String toString() {
        return "SliceExpression{start=" + this.start + ", stop=" + this.stop + ", step=" + this.step + '}';
    }
}

