/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.jmespath;

import java.util.Map;
import java.util.Set;
import software.amazon.smithy.jmespath.ExpressionVisitor;
import software.amazon.smithy.jmespath.JmespathException;
import software.amazon.smithy.jmespath.JmespathExpression;
import software.amazon.smithy.jmespath.ast.AndExpression;
import software.amazon.smithy.jmespath.ast.BinaryExpression;
import software.amazon.smithy.jmespath.ast.ComparatorExpression;
import software.amazon.smithy.jmespath.ast.CurrentExpression;
import software.amazon.smithy.jmespath.ast.ExpressionTypeExpression;
import software.amazon.smithy.jmespath.ast.FieldExpression;
import software.amazon.smithy.jmespath.ast.FilterProjectionExpression;
import software.amazon.smithy.jmespath.ast.FlattenExpression;
import software.amazon.smithy.jmespath.ast.FunctionExpression;
import software.amazon.smithy.jmespath.ast.IndexExpression;
import software.amazon.smithy.jmespath.ast.LiteralExpression;
import software.amazon.smithy.jmespath.ast.MultiSelectHashExpression;
import software.amazon.smithy.jmespath.ast.MultiSelectListExpression;
import software.amazon.smithy.jmespath.ast.NotExpression;
import software.amazon.smithy.jmespath.ast.ObjectProjectionExpression;
import software.amazon.smithy.jmespath.ast.OrExpression;
import software.amazon.smithy.jmespath.ast.ProjectionExpression;
import software.amazon.smithy.jmespath.ast.SliceExpression;
import software.amazon.smithy.jmespath.ast.Subexpression;

public final class ExpressionSerializer {
    public String serialize(JmespathExpression expression) {
        StringBuilder builder = new StringBuilder();
        Visitor visitor = new Visitor(builder);
        expression.accept(visitor);
        return builder.toString();
    }

    private static final class Visitor
    implements ExpressionVisitor<Void> {
        private final StringBuilder builder;

        Visitor(StringBuilder builder) {
            this.builder = builder;
        }

        @Override
        public Void visitComparator(ComparatorExpression expression) {
            expression.getLeft().accept(this);
            this.builder.append(' ');
            this.builder.append((Object)expression.getComparator());
            this.builder.append(' ');
            expression.getRight().accept(this);
            return null;
        }

        @Override
        public Void visitCurrentNode(CurrentExpression expression) {
            this.builder.append('@');
            return null;
        }

        @Override
        public Void visitExpressionType(ExpressionTypeExpression expression) {
            this.builder.append("&(");
            expression.getExpression().accept(this);
            this.builder.append(')');
            return null;
        }

        @Override
        public Void visitFlatten(FlattenExpression expression) {
            expression.getExpression().accept(this);
            this.builder.append("[]");
            return null;
        }

        @Override
        public Void visitFunction(FunctionExpression expression) {
            this.builder.append(expression.getName());
            this.builder.append('(');
            for (int i = 0; i < expression.getArguments().size(); ++i) {
                expression.getArguments().get(i).accept(this);
                if (i >= expression.getArguments().size() - 1) continue;
                this.builder.append(", ");
            }
            this.builder.append(')');
            return null;
        }

        @Override
        public Void visitField(FieldExpression expression) {
            this.builder.append('\"');
            this.builder.append(this.sanitizeString(expression.getName(), false));
            this.builder.append('\"');
            return null;
        }

        private String sanitizeString(String str, boolean escapeBackticks) {
            String result = str.replace("\\", "\\\\").replace("\"", "\\\"");
            if (escapeBackticks) {
                result = result.replace("`", "\\`");
            }
            return result;
        }

        @Override
        public Void visitIndex(IndexExpression expression) {
            this.builder.append('[').append(expression.getIndex()).append(']');
            return null;
        }

        @Override
        public Void visitLiteral(LiteralExpression expression) {
            this.visitLiteral(expression, false);
            return null;
        }

        private void visitLiteral(LiteralExpression expression, boolean nestedInsideLiteral) {
            if (!nestedInsideLiteral) {
                this.builder.append('`');
            }
            switch (expression.getType()) {
                case NUMBER: {
                    this.builder.append(expression.expectNumberValue());
                    break;
                }
                case NULL: 
                case ANY: {
                    this.builder.append("null");
                    break;
                }
                case ARRAY: {
                    this.builder.append('[');
                    int ai = 0;
                    for (Object value : expression.expectArrayValue()) {
                        LiteralExpression exp = LiteralExpression.from(value);
                        this.visitLiteral(exp, true);
                        if (ai++ >= expression.expectArrayValue().size() - 1) continue;
                        this.builder.append(", ");
                    }
                    this.builder.append(']');
                    break;
                }
                case OBJECT: {
                    this.builder.append('{');
                    int oi = 0;
                    Set<Map.Entry<String, Object>> objectEntries = expression.expectObjectValue().entrySet();
                    for (Map.Entry<String, Object> objectEntry : objectEntries) {
                        this.builder.append('\"').append(this.sanitizeString(objectEntry.getKey(), true)).append("\": ");
                        LiteralExpression exp = LiteralExpression.from(objectEntry.getValue());
                        this.visitLiteral(exp, true);
                        if (oi++ >= objectEntries.size() - 1) continue;
                        this.builder.append(", ");
                    }
                    this.builder.append('}');
                    break;
                }
                case STRING: {
                    this.builder.append('\"').append(this.sanitizeString(expression.expectStringValue(), true)).append('\"');
                    break;
                }
                case BOOLEAN: {
                    this.builder.append(expression.expectBooleanValue());
                    break;
                }
                default: {
                    throw new JmespathException("Unable to serialize literal runtime value: " + expression);
                }
            }
            if (!nestedInsideLiteral) {
                this.builder.append('`');
            }
        }

        @Override
        public Void visitMultiSelectList(MultiSelectListExpression expression) {
            this.builder.append('[');
            for (int i = 0; i < expression.getExpressions().size(); ++i) {
                expression.getExpressions().get(i).accept(this);
                if (i >= expression.getExpressions().size() - 1) continue;
                this.builder.append(", ");
            }
            this.builder.append(']');
            return null;
        }

        @Override
        public Void visitMultiSelectHash(MultiSelectHashExpression expression) {
            this.builder.append('{');
            int i = 0;
            for (Map.Entry<String, JmespathExpression> entry : expression.getExpressions().entrySet()) {
                this.builder.append('\"').append(this.sanitizeString(entry.getKey(), false)).append("\": ");
                entry.getValue().accept(this);
                if (i < expression.getExpressions().entrySet().size() - 1) {
                    this.builder.append(", ");
                }
                ++i;
            }
            this.builder.append('}');
            return null;
        }

        @Override
        public Void visitAnd(AndExpression expression) {
            this.builder.append('(');
            expression.getLeft().accept(this);
            this.builder.append(" && ");
            expression.getRight().accept(this);
            this.builder.append(')');
            return null;
        }

        @Override
        public Void visitOr(OrExpression expression) {
            this.builder.append('(');
            expression.getLeft().accept(this);
            this.builder.append(" || ");
            expression.getRight().accept(this);
            this.builder.append(')');
            return null;
        }

        @Override
        public Void visitNot(NotExpression expression) {
            this.builder.append("!(");
            expression.getExpression().accept(this);
            this.builder.append(')');
            return null;
        }

        @Override
        public Void visitProjection(ProjectionExpression expression) {
            if (!(expression.getLeft() instanceof CurrentExpression)) {
                expression.getLeft().accept(this);
            }
            if (!(expression.getLeft() instanceof SliceExpression) && !(expression.getLeft() instanceof FlattenExpression)) {
                this.builder.append("[*]");
            }
            if (!(expression.getRight() instanceof CurrentExpression)) {
                if (this.rhsNeedsDot(expression.getRight())) {
                    this.builder.append('.');
                }
                expression.getRight().accept(this);
            }
            return null;
        }

        @Override
        public Void visitFilterProjection(FilterProjectionExpression expression) {
            if (!(expression.getLeft() instanceof CurrentExpression)) {
                expression.getLeft().accept(this);
            }
            this.builder.append("[?");
            expression.getComparison().accept(this);
            this.builder.append(']');
            if (!(expression.getRight() instanceof CurrentExpression)) {
                if (this.rhsNeedsDot(expression.getRight())) {
                    this.builder.append('.');
                }
                expression.getRight().accept(this);
            }
            return null;
        }

        @Override
        public Void visitObjectProjection(ObjectProjectionExpression expression) {
            if (!(expression.getLeft() instanceof CurrentExpression)) {
                expression.getLeft().accept(this);
                this.builder.append(".*");
            } else {
                this.builder.append('*');
            }
            if (!(expression.getRight() instanceof CurrentExpression)) {
                if (this.rhsNeedsDot(expression.getRight())) {
                    this.builder.append('.');
                }
                expression.getRight().accept(this);
            }
            return null;
        }

        @Override
        public Void visitSlice(SliceExpression expression) {
            this.builder.append('[');
            expression.getStart().ifPresent(this.builder::append);
            this.builder.append(':');
            expression.getStop().ifPresent(this.builder::append);
            this.builder.append(':');
            this.builder.append(expression.getStep());
            this.builder.append(']');
            return null;
        }

        @Override
        public Void visitSubexpression(Subexpression expression) {
            expression.getLeft().accept(this);
            if (expression.isPipe()) {
                this.builder.append(" | ");
            } else if (this.rhsNeedsDot(expression.getRight())) {
                this.builder.append('.');
            }
            expression.getRight().accept(this);
            return null;
        }

        private boolean rhsNeedsDot(JmespathExpression expression) {
            return expression instanceof FieldExpression || expression instanceof MultiSelectHashExpression || expression instanceof MultiSelectListExpression || expression instanceof ObjectProjectionExpression || expression instanceof FunctionExpression || expression instanceof BinaryExpression && this.rhsNeedsDot(((BinaryExpression)expression).getLeft());
        }
    }
}

