/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.jmespath.ast;

import java.util.Objects;
import software.amazon.smithy.jmespath.JmespathExpression;

public abstract class BinaryExpression
extends JmespathExpression {
    private final JmespathExpression left;
    private final JmespathExpression right;

    public BinaryExpression(JmespathExpression left, JmespathExpression right, int line, int column) {
        super(line, column);
        this.left = left;
        this.right = right;
    }

    public final JmespathExpression getLeft() {
        return this.left;
    }

    public final JmespathExpression getRight() {
        return this.right;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof BinaryExpression) || o.getClass() != o.getClass()) {
            return false;
        }
        BinaryExpression that = (BinaryExpression)o;
        return this.getLeft().equals(that.getLeft()) && this.getRight().equals(that.getRight());
    }

    public int hashCode() {
        return Objects.hash(this.getLeft(), this.getRight());
    }

    public String toString() {
        return this.getClass().getSimpleName() + "{left=" + this.left + ", right=" + this.right + '}';
    }
}

