/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.diff.evaluators;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.stream.Stream;
import software.amazon.smithy.diff.ChangedShape;
import software.amazon.smithy.diff.Differences;
import software.amazon.smithy.diff.evaluators.AbstractDiffEvaluator;
import software.amazon.smithy.model.FromSourceLocation;
import software.amazon.smithy.model.Model;
import software.amazon.smithy.model.SourceLocation;
import software.amazon.smithy.model.knowledge.NullableIndex;
import software.amazon.smithy.model.node.Node;
import software.amazon.smithy.model.shapes.MemberShape;
import software.amazon.smithy.model.shapes.Shape;
import software.amazon.smithy.model.shapes.ShapeId;
import software.amazon.smithy.model.shapes.ShapeType;
import software.amazon.smithy.model.shapes.StructureShape;
import software.amazon.smithy.model.shapes.ToShapeId;
import software.amazon.smithy.model.traits.ClientOptionalTrait;
import software.amazon.smithy.model.traits.DefaultTrait;
import software.amazon.smithy.model.traits.InputTrait;
import software.amazon.smithy.model.traits.RequiredTrait;
import software.amazon.smithy.model.validation.Severity;
import software.amazon.smithy.model.validation.ValidationEvent;

public final class ChangedNullability
extends AbstractDiffEvaluator {
    @Override
    public List<ValidationEvent> evaluate(Differences differences) {
        NullableIndex oldIndex = NullableIndex.of((Model)differences.getOldModel());
        NullableIndex newIndex = NullableIndex.of((Model)differences.getNewModel());
        HashSet events = new HashSet();
        Stream.concat(differences.changedShapes(MemberShape.class), this.changedInputMembers(differences)).forEach(change -> {
            boolean isNowNullable;
            MemberShape oldShape = (MemberShape)change.getOldShape();
            MemberShape newShape = (MemberShape)change.getNewShape();
            boolean wasNullable = oldIndex.isMemberNullable(oldShape);
            if (wasNullable != (isNowNullable = newIndex.isMemberNullable(newShape))) {
                this.createErrors(differences, (ChangedShape<MemberShape>)change, wasNullable, events);
            }
        });
        return new ArrayList<ValidationEvent>(events);
    }

    private Stream<ChangedShape<MemberShape>> changedInputMembers(Differences differences) {
        return differences.changedShapes(StructureShape.class).filter(change -> change.isTraitAdded(InputTrait.ID) || change.isTraitRemoved(InputTrait.ID)).flatMap(change -> ((StructureShape)change.getNewShape()).members().stream().map(newMember -> {
            MemberShape old = (MemberShape)((StructureShape)change.getOldShape()).getAllMembers().get(newMember.getMemberName());
            return old == null ? null : new ChangedShape<MemberShape>(old, (MemberShape)newMember);
        }).filter(Objects::nonNull));
    }

    private void createErrors(Differences differences, ChangedShape<MemberShape> change, boolean wasNullable, Collection<ValidationEvent> events) {
        MemberShape oldMember = change.getOldShape();
        MemberShape newMember = change.getNewShape();
        String message = String.format("Member `%s` changed from %s to %s", oldMember.getMemberName(), wasNullable ? "nullable" : "non-nullable", wasNullable ? "non-nullable" : "nullable");
        ShapeId shape = change.getShapeId();
        SourceLocation oldMemberSourceLocation = oldMember.getSourceLocation();
        Shape newTarget = differences.getNewModel().expectShape(newMember.getTarget());
        ArrayList<ValidationEvent> eventsToAdd = new ArrayList<ValidationEvent>();
        SourceLocation newMemberContainerSource = differences.getNewModel().expectShape(newMember.getContainer()).getSourceLocation();
        boolean oldHasInput = this.hasInputTrait(differences.getOldModel(), oldMember);
        boolean newHasInput = this.hasInputTrait(differences.getNewModel(), newMember);
        if (oldHasInput && !newHasInput) {
            this.addRemovedInputTrait(eventsToAdd, shape, newMemberContainerSource, message, newMember.getContainer());
        } else if (!oldHasInput && newHasInput) {
            this.addAddedInputTrait(eventsToAdd, shape, newMemberContainerSource, message, newMember.getContainer());
        } else if (!newHasInput && !oldHasInput) {
            ShapeType type;
            if (change.isTraitAdded(ClientOptionalTrait.ID) && change.isTraitInBoth(RequiredTrait.ID)) {
                this.addAddedClientOptionalTrait(eventsToAdd, shape, oldMemberSourceLocation, message);
            } else if (change.isTraitRemoved(ClientOptionalTrait.ID) && change.isTraitInBoth(RequiredTrait.ID)) {
                this.addRemovedClientOptionalTrait(eventsToAdd, shape, oldMemberSourceLocation, message);
            } else if (change.isTraitAdded(RequiredTrait.ID) && !newMember.hasTrait(ClientOptionalTrait.ID)) {
                if (newTarget.isStructureShape() || newTarget.isUnionShape()) {
                    type = newTarget.getType();
                    this.addAddedRequiredTraitStructureOrUnion(eventsToAdd, shape, oldMemberSourceLocation, message, type);
                } else {
                    this.addAddedRequiredTrait(eventsToAdd, shape, oldMemberSourceLocation, message);
                }
            }
            if (change.isTraitAdded(DefaultTrait.ID) && !change.isTraitRemoved(RequiredTrait.ID)) {
                this.addAddedDefaultTrait(eventsToAdd, shape, oldMemberSourceLocation, message);
            }
            if (change.isTraitRemoved(RequiredTrait.ID) && !newMember.hasTrait(DefaultTrait.ID) && !oldMember.hasTrait(ClientOptionalTrait.ID)) {
                if (newTarget.isStructureShape() || newTarget.isUnionShape()) {
                    type = newTarget.getType();
                    this.addRemovedRequiredTraitStructureOrUnion(eventsToAdd, shape, oldMemberSourceLocation, message, type);
                } else {
                    this.addRemovedRequiredTrait(eventsToAdd, shape, oldMemberSourceLocation, message);
                }
            }
        }
        if (change.isTraitInBoth(DefaultTrait.ID)) {
            Node oldValue = ((DefaultTrait)oldMember.getTrait(DefaultTrait.class).get()).toNode();
            Node newValue = ((DefaultTrait)newMember.getTrait(DefaultTrait.class).get()).toNode();
            boolean isOldDefaultNullable = oldValue.isNullNode();
            boolean isNewDefaultNullable = newValue.isNullNode();
            if (!isOldDefaultNullable && isNewDefaultNullable) {
                this.addAddedNullDefault(eventsToAdd, shape, oldMemberSourceLocation, message, oldValue);
            } else if (isOldDefaultNullable && !isNewDefaultNullable) {
                this.addRemovedNullDefault(eventsToAdd, shape, oldMemberSourceLocation, message, newValue);
            }
        }
        if (eventsToAdd.isEmpty()) {
            eventsToAdd.add(this.emit(Severity.ERROR, null, shape, oldMemberSourceLocation, null, message));
        }
        events.addAll(eventsToAdd);
    }

    private void addRemovedInputTrait(List<ValidationEvent> eventsToAdd, ShapeId shape, SourceLocation location, String message, ShapeId container) {
        eventsToAdd.add(this.emit(Severity.ERROR, "RemovedInputTrait", shape, location, message, "The `@input` trait was removed from " + container));
    }

    private void addAddedInputTrait(List<ValidationEvent> eventsToAdd, ShapeId shape, SourceLocation location, String message, ShapeId container) {
        eventsToAdd.add(this.emit(Severity.DANGER, "AddedInputTrait", shape, location, message, "The `@input` trait was added to " + container));
    }

    private void addAddedClientOptionalTrait(List<ValidationEvent> eventsToAdd, ShapeId shape, SourceLocation location, String message) {
        eventsToAdd.add(this.emit(Severity.ERROR, "AddedClientOptionalTrait", shape, location, message, "The `@clientOptional` trait was added to a `@required` member."));
    }

    private void addRemovedClientOptionalTrait(List<ValidationEvent> eventsToAdd, ShapeId shape, SourceLocation location, String message) {
        eventsToAdd.add(this.emit(Severity.ERROR, "RemovedClientOptionalTrait", shape, location, message, "The `@clientOptional` trait was removed from a `@required` member."));
    }

    private void addAddedRequiredTraitStructureOrUnion(List<ValidationEvent> eventsToAdd, ShapeId shape, SourceLocation location, String message, ShapeType targetType) {
        eventsToAdd.add(this.emit(Severity.WARNING, "AddedRequiredTrait.StructureOrUnion", shape, location, message, "The `@required` trait was added to a member that targets a " + targetType + ". This is backward compatible in generators that always treat structures and unions as optional (e.g., AWS generators)"));
    }

    private void addAddedRequiredTrait(List<ValidationEvent> eventsToAdd, ShapeId shape, SourceLocation location, String message) {
        eventsToAdd.add(this.emit(Severity.ERROR, "AddedRequiredTrait", shape, location, message, "The `@required` trait was added to a member."));
    }

    private void addAddedDefaultTrait(List<ValidationEvent> eventsToAdd, ShapeId shape, SourceLocation location, String message) {
        eventsToAdd.add(this.emit(Severity.ERROR, "AddedDefaultTrait", shape, location, message, "The `@default` trait was added to a member that was not previously `@required`."));
    }

    private void addRemovedRequiredTraitStructureOrUnion(List<ValidationEvent> eventsToAdd, ShapeId shape, SourceLocation location, String message, ShapeType targetType) {
        eventsToAdd.add(this.emit(Severity.WARNING, "RemovedRequiredTrait.StructureOrUnion", shape, location, message, "The @required trait was removed from a member that targets a " + targetType + ". This is backward compatible in generators that always treat structures and unions as optional (e.g., AWS generators)"));
    }

    private void addRemovedRequiredTrait(List<ValidationEvent> eventsToAdd, ShapeId shape, SourceLocation location, String message) {
        eventsToAdd.add(this.emit(Severity.ERROR, "RemovedRequiredTrait", shape, location, message, "The @required trait was removed and not replaced with the @default trait and @addedDefault trait."));
    }

    private void addAddedNullDefault(List<ValidationEvent> eventsToAdd, ShapeId shape, SourceLocation location, String message, Node value) {
        eventsToAdd.add(this.emit(Severity.ERROR, "AddedNullDefault", shape, location, message, "The `@default` trait was changed from `" + value + "` to `null`."));
    }

    private void addRemovedNullDefault(List<ValidationEvent> eventsToAdd, ShapeId shape, SourceLocation location, String message, Node value) {
        eventsToAdd.add(this.emit(Severity.ERROR, "RemovedNullDefault", shape, location, message, "The `@default` trait was changed from `null` to `" + value + "`."));
    }

    private boolean hasInputTrait(Model model, MemberShape member) {
        return model.getShape(member.getContainer()).filter(shape -> shape.hasTrait(InputTrait.ID)).isPresent();
    }

    private ValidationEvent emit(Severity severity, String eventIdSuffix, ShapeId shape, SourceLocation sourceLocation, String prefixMessage, String message) {
        String actualId = eventIdSuffix == null ? this.getEventId() : this.getEventId() + '.' + eventIdSuffix;
        String actualMessage = prefixMessage == null ? message : prefixMessage + ": " + message;
        return ValidationEvent.builder().id(actualId).shapeId((ToShapeId)shape).sourceLocation((FromSourceLocation)sourceLocation).message(actualMessage).severity(severity).build();
    }
}

