/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.diff.evaluators;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import software.amazon.smithy.diff.ChangedShape;
import software.amazon.smithy.diff.Differences;
import software.amazon.smithy.diff.evaluators.AbstractDiffEvaluator;
import software.amazon.smithy.model.shapes.EntityShape;
import software.amazon.smithy.model.shapes.Shape;
import software.amazon.smithy.model.shapes.ShapeId;
import software.amazon.smithy.model.shapes.ShapeType;
import software.amazon.smithy.model.validation.Severity;
import software.amazon.smithy.model.validation.ValidationEvent;

public final class RemovedEntityBinding
extends AbstractDiffEvaluator {
    private static final String REMOVED_RESOURCE = "RemovedResourceBinding";
    private static final String REMOVED_OPERATION = "RemovedOperationBinding";
    private static final String FROM_RESOURCE = ".FromResource.";
    private static final String FROM_SERVICE = ".FromService.";

    @Override
    public List<ValidationEvent> evaluate(Differences differences) {
        ArrayList<ValidationEvent> events = new ArrayList<ValidationEvent>();
        differences.changedShapes(EntityShape.class).forEach(change -> this.validateOperation((ChangedShape<EntityShape>)change, (List<ValidationEvent>)events));
        return events;
    }

    private void validateOperation(ChangedShape<EntityShape> change, List<ValidationEvent> events) {
        this.findRemoved(change.getOldShape().getOperations(), change.getNewShape().getOperations()).forEach(removed -> events.add(this.createRemovedEvent(REMOVED_OPERATION, (EntityShape)change.getNewShape(), (ShapeId)removed)));
        this.findRemoved(change.getOldShape().getResources(), change.getNewShape().getResources()).forEach(removed -> events.add(this.createRemovedEvent(REMOVED_RESOURCE, (EntityShape)change.getNewShape(), (ShapeId)removed)));
    }

    private Set<ShapeId> findRemoved(Set<ShapeId> oldShapes, Set<ShapeId> newShapes) {
        HashSet<ShapeId> removed = new HashSet<ShapeId>(oldShapes);
        removed.removeAll(newShapes);
        return removed;
    }

    private ValidationEvent createRemovedEvent(String typeOfRemoval, EntityShape parentEntity, ShapeId childShape) {
        String childType = typeOfRemoval.equals(REMOVED_RESOURCE) ? "Resource" : "Operation";
        String typeOfParentShape = ShapeType.RESOURCE.equals((Object)parentEntity.getType()) ? FROM_RESOURCE : FROM_SERVICE;
        String message = String.format("%s binding of `%s` was removed from %s shape, `%s`", childType, childShape, parentEntity.getType(), parentEntity.getId());
        return ValidationEvent.builder().id(typeOfRemoval + typeOfParentShape + childShape.getName()).severity(Severity.ERROR).shape((Shape)parentEntity).message(message).build();
    }
}

