/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.diff.evaluators;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import software.amazon.smithy.diff.Differences;
import software.amazon.smithy.diff.evaluators.AbstractDiffEvaluator;
import software.amazon.smithy.model.FromSourceLocation;
import software.amazon.smithy.model.Model;
import software.amazon.smithy.model.node.Node;
import software.amazon.smithy.model.node.ObjectNode;
import software.amazon.smithy.model.shapes.ListShape;
import software.amazon.smithy.model.shapes.MapShape;
import software.amazon.smithy.model.shapes.MemberShape;
import software.amazon.smithy.model.shapes.Shape;
import software.amazon.smithy.model.shapes.ShapeId;
import software.amazon.smithy.model.shapes.ShapeVisitor;
import software.amazon.smithy.model.shapes.StructureShape;
import software.amazon.smithy.model.shapes.UnionShape;
import software.amazon.smithy.model.traits.BoxTrait;
import software.amazon.smithy.model.traits.RequiredTrait;
import software.amazon.smithy.model.traits.Trait;
import software.amazon.smithy.model.traits.TraitDefinition;
import software.amazon.smithy.model.traits.synthetic.OriginalShapeIdTrait;
import software.amazon.smithy.model.traits.synthetic.SyntheticEnumTrait;
import software.amazon.smithy.model.validation.Severity;
import software.amazon.smithy.model.validation.ValidationEvent;
import software.amazon.smithy.model.validation.ValidationUtils;
import software.amazon.smithy.utils.ListUtils;
import software.amazon.smithy.utils.SetUtils;
import software.amazon.smithy.utils.StringUtils;

public final class ModifiedTrait
extends AbstractDiffEvaluator {
    private static final List<DiffStrategy> DEFAULT_STRATEGIES = ListUtils.of((Object[])new DiffStrategy[]{new DiffStrategy(DiffType.ADD, Severity.NOTE), new DiffStrategy(DiffType.UPDATE, Severity.NOTE), new DiffStrategy(DiffType.REMOVE, Severity.WARNING)});
    private static final Set<ShapeId> IGNORED_TRAITS = SetUtils.of((Object[])new ShapeId[]{BoxTrait.ID, RequiredTrait.ID, SyntheticEnumTrait.ID, OriginalShapeIdTrait.ID});

    @Override
    public List<ValidationEvent> evaluate(Differences differences) {
        Map<ShapeId, List<DiffStrategy>> strategies = ModifiedTrait.computeDiffStrategies(differences.getNewModel());
        ArrayList<ValidationEvent> events = new ArrayList<ValidationEvent>();
        differences.changedShapes().forEach(changedShape -> changedShape.getTraitDifferences().forEach((traitId, oldTraitNewTraitPair) -> {
            Trait oldTrait = (Trait)oldTraitNewTraitPair.left;
            Trait newTrait = (Trait)oldTraitNewTraitPair.right;
            if (!IGNORED_TRAITS.contains(traitId)) {
                List diffStrategies = strategies.computeIfAbsent((ShapeId)traitId, t -> ListUtils.of((Object)new DiffStrategy(DiffType.CONST, Severity.WARNING)));
                for (DiffStrategy strategy : diffStrategies) {
                    List<ValidationEvent> diffEvents = strategy.diffType.validate(differences.getNewModel(), "", (Shape)changedShape.getNewShape(), (ShapeId)traitId, oldTrait == null ? null : oldTrait.toNode(), newTrait == null ? null : newTrait.toNode(), strategy.severity);
                    events.addAll(diffEvents);
                }
            }
        }));
        return events;
    }

    private static Map<ShapeId, List<DiffStrategy>> computeDiffStrategies(Model model) {
        HashMap<ShapeId, List<DiffStrategy>> result = new HashMap<ShapeId, List<DiffStrategy>>();
        for (Shape shape : model.getShapesWithTrait(TraitDefinition.class)) {
            TraitDefinition definition = (TraitDefinition)shape.expectTrait(TraitDefinition.class);
            List<DiffStrategy> strategies = ModifiedTrait.createStrategiesForShape(shape, true);
            if (!strategies.isEmpty()) {
                result.put(shape.getId(), strategies);
                continue;
            }
            if (!definition.getBreakingChanges().isEmpty()) {
                result.put(shape.getId(), Collections.emptyList());
                continue;
            }
            result.put(shape.getId(), DEFAULT_STRATEGIES);
        }
        return result;
    }

    private static List<DiffStrategy> createStrategiesForShape(Shape shape, boolean allowContents) {
        ArrayList<DiffStrategy> strategies = new ArrayList<DiffStrategy>();
        for (String tag : shape.getTags()) {
            DiffStrategy value = DiffStrategy.fromTag(tag, allowContents);
            if (value == null) continue;
            strategies.add(value);
        }
        return strategies;
    }

    private static void crawlContents(Model model, Shape startingShape, ShapeId trait, Shape currentTraitShape, Node leftValue, Node rightValue, List<ValidationEvent> events, String path) {
        currentTraitShape.accept((ShapeVisitor)new DiffCrawler(model, startingShape, trait, leftValue, rightValue, events, path));
    }

    private static final class DiffStrategy {
        private final DiffType diffType;
        private final Severity severity;

        DiffStrategy(DiffType diffType, Severity severity) {
            this.diffType = diffType;
            this.severity = severity;
        }

        private static DiffStrategy fromTag(String tag, boolean allowContents) {
            switch (tag) {
                case "diff.contents": {
                    return allowContents ? new DiffStrategy(DiffType.CONTENTS, null) : null;
                }
                case "diff.error.add": {
                    return new DiffStrategy(DiffType.ADD, Severity.ERROR);
                }
                case "diff.error.remove": {
                    return new DiffStrategy(DiffType.REMOVE, Severity.ERROR);
                }
                case "diff.error.update": {
                    return new DiffStrategy(DiffType.UPDATE, Severity.ERROR);
                }
                case "diff.error.const": {
                    return new DiffStrategy(DiffType.CONST, Severity.ERROR);
                }
                case "diff.danger.add": {
                    return new DiffStrategy(DiffType.ADD, Severity.DANGER);
                }
                case "diff.danger.remove": {
                    return new DiffStrategy(DiffType.REMOVE, Severity.DANGER);
                }
                case "diff.danger.update": {
                    return new DiffStrategy(DiffType.UPDATE, Severity.DANGER);
                }
                case "diff.danger.const": {
                    return new DiffStrategy(DiffType.CONST, Severity.DANGER);
                }
                case "diff.warning.add": {
                    return new DiffStrategy(DiffType.ADD, Severity.WARNING);
                }
                case "diff.warning.remove": {
                    return new DiffStrategy(DiffType.REMOVE, Severity.WARNING);
                }
                case "diff.warning.update": {
                    return new DiffStrategy(DiffType.UPDATE, Severity.WARNING);
                }
                case "diff.warning.const": {
                    return new DiffStrategy(DiffType.CONST, Severity.WARNING);
                }
            }
            return null;
        }
    }

    private static final class DiffCrawler
    extends ShapeVisitor.Default<Void> {
        private final Model model;
        private final Shape startingShape;
        private final ShapeId trait;
        private final Node leftValue;
        private final Node rightValue;
        private final List<ValidationEvent> events;
        private final String path;

        DiffCrawler(Model model, Shape startingShape, ShapeId trait, Node leftValue, Node rightValue, List<ValidationEvent> events, String path) {
            this.model = model;
            this.startingShape = startingShape;
            this.trait = trait;
            this.leftValue = leftValue;
            this.rightValue = rightValue;
            this.events = events;
            this.path = path;
        }

        public Void listShape(ListShape shape) {
            if (this.leftValue != null && this.rightValue != null && this.leftValue.isArrayNode() && this.rightValue.isArrayNode()) {
                Node element;
                int i;
                List leftValues = this.leftValue.expectArrayNode().getElements();
                List rightValues = this.rightValue.expectArrayNode().getElements();
                for (i = 0; i < leftValues.size(); ++i) {
                    element = (Node)leftValues.get(i);
                    if (rightValues.size() > i) {
                        ModifiedTrait.crawlContents(this.model, this.startingShape, this.trait, (Shape)shape.getMember(), element, (Node)rightValues.get(i), this.events, this.path + '/' + i);
                        continue;
                    }
                    ModifiedTrait.crawlContents(this.model, this.startingShape, this.trait, (Shape)shape.getMember(), element, null, this.events, this.path + '/' + i);
                }
                for (i = 0; i < rightValues.size(); ++i) {
                    element = (Node)rightValues.get(i);
                    if (leftValues.size() > i) continue;
                    ModifiedTrait.crawlContents(this.model, this.startingShape, this.trait, (Shape)shape.getMember(), null, element, this.events, this.path + '/' + i);
                }
            }
            return null;
        }

        public Void mapShape(MapShape shape) {
            if (this.leftValue != null && this.rightValue != null && this.leftValue.isObjectNode() && this.rightValue.isObjectNode()) {
                Map leftValues = this.leftValue.expectObjectNode().getStringMap();
                Map rightValues = this.rightValue.expectObjectNode().getStringMap();
                for (Map.Entry entry : leftValues.entrySet()) {
                    Node rightValue = (Node)rightValues.get(entry.getKey());
                    ModifiedTrait.crawlContents(this.model, this.startingShape, this.trait, (Shape)shape.getValue(), (Node)entry.getValue(), rightValue, this.events, this.path + '/' + (String)entry.getKey());
                }
                for (Map.Entry entry : rightValues.entrySet()) {
                    if (leftValues.containsKey(entry.getKey())) continue;
                    ModifiedTrait.crawlContents(this.model, this.startingShape, this.trait, (Shape)shape.getValue(), null, (Node)entry.getValue(), this.events, this.path + '/' + (String)entry.getKey());
                }
            }
            return null;
        }

        public Void structureShape(StructureShape shape) {
            this.crawlStructuredShape((Shape)shape);
            return null;
        }

        public Void unionShape(UnionShape shape) {
            this.crawlStructuredShape((Shape)shape);
            return null;
        }

        private void crawlStructuredShape(Shape shape) {
            if (this.leftValue != null && this.rightValue != null && this.leftValue.isObjectNode() && this.rightValue.isObjectNode()) {
                ObjectNode leftObj = this.leftValue.expectObjectNode();
                ObjectNode rightObj = this.rightValue.expectObjectNode();
                for (MemberShape member : shape.members()) {
                    Node leftValue = leftObj.getMember(member.getMemberName()).orElse(null);
                    Node rightValue = rightObj.getMember(member.getMemberName()).orElse(null);
                    if (leftValue == null && rightValue == null) continue;
                    ModifiedTrait.crawlContents(this.model, this.startingShape, this.trait, (Shape)member, leftValue, rightValue, this.events, this.path + '/' + member.getMemberName());
                }
            }
        }

        public Void memberShape(MemberShape shape) {
            List strategies = ModifiedTrait.createStrategiesForShape((Shape)shape, false);
            for (DiffStrategy strategy : strategies) {
                this.events.addAll(strategy.diffType.validate(this.model, this.path, this.startingShape, this.trait, this.leftValue, this.rightValue, strategy.severity));
            }
            this.model.getShape(shape.getTarget()).ifPresent(target -> ModifiedTrait.crawlContents(this.model, this.startingShape, this.trait, target, this.leftValue, this.rightValue, this.events, this.path));
            return null;
        }

        protected Void getDefault(Shape shape) {
            return null;
        }
    }

    private static enum DiffType {
        ADD{

            @Override
            List<ValidationEvent> validate(Model model, String path, Shape shape, ShapeId trait, Node left, Node right, Severity severity) {
                if (left != null) {
                    return Collections.emptyList();
                }
                String pretty = ValidationUtils.tickedPrettyPrintedNode((Node)right);
                String message = path.isEmpty() ? String.format("Added trait `%s` with value %s", trait, pretty) : String.format("Added trait contents to `%s` at path `%s` with value %s", trait, path, pretty);
                return Collections.singletonList(ValidationEvent.builder().id(DiffType.getValidationEventId((DiffType)this, trait)).severity(severity).shape(shape).sourceLocation((FromSourceLocation)right).message(message).build());
            }
        }
        ,
        REMOVE{

            @Override
            List<ValidationEvent> validate(Model model, String path, Shape shape, ShapeId trait, Node left, Node right, Severity severity) {
                if (right != null) {
                    return Collections.emptyList();
                }
                String pretty = ValidationUtils.tickedPrettyPrintedNode((Node)left);
                String message = path.isEmpty() ? String.format("Removed trait `%s`. Previous trait value: %s", trait, pretty) : String.format("Removed trait contents from `%s` at path `%s`. Removed value: %s", trait, path, pretty);
                return Collections.singletonList(ValidationEvent.builder().id(DiffType.getValidationEventId((DiffType)this, trait)).severity(severity).shape(shape).sourceLocation((FromSourceLocation)left.getSourceLocation()).message(message).build());
            }
        }
        ,
        UPDATE{

            @Override
            List<ValidationEvent> validate(Model model, String path, Shape shape, ShapeId trait, Node left, Node right, Severity severity) {
                if (left == null || right == null || Objects.equals(left, right)) {
                    return Collections.emptyList();
                }
                String leftPretty = ValidationUtils.tickedPrettyPrintedNode((Node)left);
                String rightPretty = ValidationUtils.tickedPrettyPrintedNode((Node)right);
                String message = path.isEmpty() ? String.format("Changed trait `%s` from %s to %s", trait, leftPretty, rightPretty) : String.format("Changed trait contents of `%s` at path `%s` from %s to %s", trait, path, leftPretty, rightPretty);
                return Collections.singletonList(ValidationEvent.builder().id(DiffType.getValidationEventId((DiffType)this, trait)).severity(severity).shape(shape).message(message).build());
            }
        }
        ,
        CONST{

            @Override
            List<ValidationEvent> validate(Model model, String path, Shape shape, ShapeId trait, Node left, Node right, Severity severity) {
                ArrayList<ValidationEvent> events = new ArrayList<ValidationEvent>();
                events.addAll(ADD.validate(model, path, shape, trait, left, right, severity));
                events.addAll(REMOVE.validate(model, path, shape, trait, left, right, severity));
                events.addAll(UPDATE.validate(model, path, shape, trait, left, right, severity));
                return events;
            }
        }
        ,
        CONTENTS{

            @Override
            List<ValidationEvent> validate(Model model, String path, Shape shape, ShapeId trait, Node left, Node right, Severity severity) {
                if (left == null || right == null) {
                    return Collections.emptyList();
                }
                Shape traitShape = model.getShape(trait).orElse(null);
                if (traitShape == null) {
                    return Collections.emptyList();
                }
                ArrayList<ValidationEvent> events = new ArrayList<ValidationEvent>();
                ModifiedTrait.crawlContents(model, shape, trait, traitShape, left, right, events, "");
                return events;
            }
        };


        abstract List<ValidationEvent> validate(Model var1, String var2, Shape var3, ShapeId var4, Node var5, Node var6, Severity var7);

        private static String getValidationEventId(DiffType diffType, ShapeId trait) {
            return String.format("%s.%s.%s", ModifiedTrait.class.getSimpleName(), StringUtils.capitalize((String)StringUtils.lowerCase((String)diffType.toString())), trait);
        }
    }
}

