/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.diff.evaluators;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import software.amazon.smithy.diff.Differences;
import software.amazon.smithy.diff.evaluators.AbstractDiffEvaluator;
import software.amazon.smithy.model.FromSourceLocation;
import software.amazon.smithy.model.Model;
import software.amazon.smithy.model.node.Node;
import software.amazon.smithy.model.node.ToNode;
import software.amazon.smithy.model.shapes.CollectionShape;
import software.amazon.smithy.model.shapes.MapShape;
import software.amazon.smithy.model.shapes.Shape;
import software.amazon.smithy.model.traits.Trait;
import software.amazon.smithy.model.traits.TraitDefinition;
import software.amazon.smithy.model.validation.ValidationEvent;
import software.amazon.smithy.model.validation.ValidationUtils;
import software.amazon.smithy.utils.StringUtils;

public final class TraitBreakingChange
extends AbstractDiffEvaluator {
    private static final List<TraitDefinition.ChangeType> ANY_TYPES = Arrays.asList(TraitDefinition.ChangeType.ADD, TraitDefinition.ChangeType.REMOVE, TraitDefinition.ChangeType.UPDATE);
    private static final List<TraitDefinition.ChangeType> PRESENCE_TYPES = Arrays.asList(TraitDefinition.ChangeType.ADD, TraitDefinition.ChangeType.REMOVE);

    @Override
    public List<ValidationEvent> evaluate(Differences differences) {
        ArrayList<ValidationEvent> events = new ArrayList<ValidationEvent>();
        differences.changedShapes().forEach(changedShape -> changedShape.getTraitDifferences().forEach((traitId, oldTraitNewTraitPair) -> {
            Trait oldTrait = (Trait)oldTraitNewTraitPair.left;
            Trait newTrait = (Trait)oldTraitNewTraitPair.right;
            differences.getNewModel().getShape(traitId).ifPresent(traitShape -> {
                List rules = ((TraitDefinition)traitShape.expectTrait(TraitDefinition.class)).getBreakingChanges();
                for (TraitDefinition.BreakingChangeRule rule : rules) {
                    PathChecker checker = new PathChecker(differences.getNewModel(), (Shape)traitShape, (Shape)changedShape.getNewShape(), rule, events);
                    checker.check(Node.from((ToNode)oldTrait), Node.from((ToNode)newTrait));
                }
            });
        }));
        return events;
    }

    private static final class PathChecker {
        private final Model model;
        private final Shape trait;
        private final Shape targetShape;
        private final TraitDefinition.BreakingChangeRule rule;
        private final List<ValidationEvent> events;
        private final List<String> segements;

        PathChecker(Model model, Shape trait, Shape targetShape, TraitDefinition.BreakingChangeRule rule, List<ValidationEvent> events) {
            this.model = model;
            this.trait = trait;
            this.targetShape = targetShape;
            this.rule = rule;
            this.events = events;
            this.segements = rule.getDefaultedPath().getParts();
        }

        private void check(Node left, Node right) {
            if (right.isNullNode() && !this.segements.isEmpty()) {
                return;
            }
            TreeMap<String, Node> leftValues = new TreeMap<String, Node>();
            TreeMap<String, Node> rightValues = new TreeMap<String, Node>();
            this.extract(leftValues, this.trait, 0, left, "");
            this.extract(rightValues, this.trait, 0, right, "");
            for (Map.Entry entry : leftValues.entrySet()) {
                Node rightValue = rightValues.getOrDefault(entry.getKey(), (Node)Node.nullNode());
                this.compareResult((String)entry.getKey(), (Node)entry.getValue(), rightValue);
            }
            for (Map.Entry entry : rightValues.entrySet()) {
                if (leftValues.containsKey(entry.getKey())) continue;
                this.compareResult((String)entry.getKey(), (Node)Node.nullNode(), (Node)entry.getValue());
            }
        }

        private void extract(Map<String, Node> result, Shape currentShape, int segmentPosition, Node currentValue, String path) {
            if (segmentPosition >= this.segements.size() || this.segements.get(segmentPosition).isEmpty()) {
                result.put(path, currentValue);
                return;
            }
            String segment = this.segements.get(segmentPosition);
            currentShape.getMember(segment).flatMap(m -> this.model.getShape(m.getTarget())).ifPresent(nextShape -> {
                if (currentShape instanceof CollectionShape) {
                    currentValue.asArrayNode().ifPresent(v -> {
                        for (int i = 0; i < v.size(); ++i) {
                            Node value = (Node)v.get(i).get();
                            this.extract(result, (Shape)nextShape, segmentPosition + 1, value, path + "/" + i);
                        }
                    });
                } else if (currentShape instanceof MapShape) {
                    currentValue.asObjectNode().ifPresent(v -> {
                        for (Map.Entry entry : v.getStringMap().entrySet()) {
                            this.extract(result, (Shape)nextShape, segmentPosition + 1, (Node)entry.getValue(), path + "/" + (String)entry.getKey());
                        }
                    });
                } else if (currentShape.isStructureShape() || currentShape.isUnionShape()) {
                    currentValue.asObjectNode().ifPresent(v -> this.extract(result, (Shape)nextShape, segmentPosition + 1, (Node)v.getMember(segment).orElse(Node.nullNode()), path + "/" + segment));
                }
            });
        }

        private void compareResult(String path, Node left, Node right) {
            TraitDefinition.ChangeType type;
            if (!(left.isNullNode() && right.isNullNode() || (type = this.isChangeBreaking(this.rule.getChange(), left, right)) == null)) {
                String message = this.createBreakingMessage(type, path, left, right);
                if (this.rule.getMessage().isPresent()) {
                    if (!message.endsWith(".")) {
                        message = message + "; ";
                    }
                    message = message + (String)this.rule.getMessage().get();
                }
                Node location = !right.isNullNode() ? right : this.targetShape;
                this.events.add(ValidationEvent.builder().id(this.getValidationEventId(type)).severity(this.rule.getDefaultedSeverity()).shape(this.targetShape).sourceLocation((FromSourceLocation)location).message(message).build());
            }
        }

        private String getValidationEventId(TraitDefinition.ChangeType type) {
            return String.format("%s.%s.%s", TraitBreakingChange.class.getSimpleName(), StringUtils.capitalize((String)type.toString()), this.trait.getId());
        }

        private TraitDefinition.ChangeType isChangeBreaking(TraitDefinition.ChangeType type, Node left, Node right) {
            switch (type) {
                case ADD: {
                    return left.isNullNode() && !right.isNullNode() ? type : null;
                }
                case REMOVE: {
                    return right.isNullNode() && !left.isNullNode() ? type : null;
                }
                case UPDATE: {
                    return !left.isNullNode() && !right.isNullNode() && !left.equals(right) ? type : null;
                }
                case ANY: {
                    for (TraitDefinition.ChangeType checkType : ANY_TYPES) {
                        if (this.isChangeBreaking(checkType, left, right) == null) continue;
                        return checkType;
                    }
                    return null;
                }
                case PRESENCE: {
                    for (TraitDefinition.ChangeType checkType : PRESENCE_TYPES) {
                        if (this.isChangeBreaking(checkType, left, right) == null) continue;
                        return checkType;
                    }
                    break;
                }
            }
            return null;
        }

        private String createBreakingMessage(TraitDefinition.ChangeType type, String path, Node left, Node right) {
            String leftPretty = ValidationUtils.tickedPrettyPrintedNode((Node)left);
            String rightPretty = ValidationUtils.tickedPrettyPrintedNode((Node)right);
            switch (type) {
                case ADD: {
                    if (!path.isEmpty()) {
                        return String.format("Added trait contents to `%s` at path `%s` with value %s", this.trait.getId(), path, rightPretty);
                    }
                    if (Node.objectNode().equals((Object)right)) {
                        return String.format("Added trait `%s`", this.trait.getId());
                    }
                    return String.format("Added trait `%s` with value %s", this.trait.getId(), rightPretty);
                }
                case REMOVE: {
                    if (!path.isEmpty()) {
                        return String.format("Removed trait contents from `%s` at path `%s`. Removed value: %s", this.trait.getId(), path, leftPretty);
                    }
                    if (Node.objectNode().equals((Object)left)) {
                        return String.format("Removed trait `%s`", this.trait.getId());
                    }
                    return String.format("Removed trait `%s`. Previous trait value: %s", this.trait.getId(), leftPretty);
                }
                case UPDATE: {
                    if (!path.isEmpty()) {
                        return String.format("Changed trait contents of `%s` at path `%s` from %s to %s", this.trait.getId(), path, leftPretty, rightPretty);
                    }
                    return String.format("Changed trait `%s` from %s to %s", this.trait.getId(), leftPretty, rightPretty);
                }
            }
            throw new UnsupportedOperationException("Expected add, remove, update: " + type);
        }
    }
}

