/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.diff.evaluators;

import java.util.ArrayList;
import java.util.List;
import software.amazon.smithy.diff.ChangedShape;
import software.amazon.smithy.diff.Differences;
import software.amazon.smithy.diff.evaluators.AbstractDiffEvaluator;
import software.amazon.smithy.model.FromSourceLocation;
import software.amazon.smithy.model.Model;
import software.amazon.smithy.model.knowledge.NullableIndex;
import software.amazon.smithy.model.node.Node;
import software.amazon.smithy.model.shapes.MemberShape;
import software.amazon.smithy.model.shapes.Shape;
import software.amazon.smithy.model.shapes.ShapeType;
import software.amazon.smithy.model.traits.AbstractTrait;
import software.amazon.smithy.model.traits.AddedDefaultTrait;
import software.amazon.smithy.model.traits.DefaultTrait;
import software.amazon.smithy.model.validation.ValidationEvent;
import software.amazon.smithy.utils.SmithyInternalApi;

@SmithyInternalApi
public final class ChangedDefault
extends AbstractDiffEvaluator {
    @Override
    public List<ValidationEvent> evaluate(Differences differences) {
        ArrayList<ValidationEvent> events = new ArrayList<ValidationEvent>();
        differences.changedShapes().forEach(change -> change.getTraitDifferences().forEach((traitId, pair) -> {
            if (traitId.equals((Object)DefaultTrait.ID) && (pair.left == null || pair.left instanceof DefaultTrait) && (pair.right == null || pair.right instanceof DefaultTrait)) {
                this.validateChange((List<ValidationEvent>)events, differences.getNewModel(), (ChangedShape<Shape>)change, (DefaultTrait)pair.left, (DefaultTrait)pair.right);
            }
        }));
        return events;
    }

    private void validateChange(List<ValidationEvent> events, Model model, ChangedShape<Shape> change, DefaultTrait oldTrait, DefaultTrait newTrait) {
        if (newTrait == null) {
            if (!this.isInconsequentialRemovalOfDefaultTrait(model, oldTrait, change.getNewShape())) {
                events.add(this.error(change.getNewShape(), "@default trait was removed. This will break previously generated code."));
            }
        } else if (oldTrait == null) {
            if (change.getNewShape().getType() != ShapeType.MEMBER) {
                events.add(this.error(change.getNewShape(), (FromSourceLocation)newTrait, "Adding the @default trait to a root-level shape will break previously generated code. Added @default: " + Node.printJson((Node)newTrait.toNode())));
            } else if (!change.getNewShape().hasTrait(AddedDefaultTrait.class) && !newTrait.toNode().isNullNode()) {
                events.add(this.error(change.getNewShape(), (FromSourceLocation)newTrait, "Adding the @default trait to a member without also adding the @addedDefault trait will break previously generated code. Added @default: " + Node.printJson((Node)newTrait.toNode())));
            }
        } else if (!oldTrait.toNode().equals(newTrait.toNode())) {
            if (change.getNewShape().isMemberShape()) {
                this.evaluateChangedTrait(model, (MemberShape)change.getNewShape().asMemberShape().get(), oldTrait, newTrait, events);
            } else {
                events.add(this.error(change.getNewShape(), (FromSourceLocation)newTrait, "Changing the @default value of a root-level shape will break previously generated code. Old value: " + Node.printJson((Node)oldTrait.toNode()) + ". New value: " + Node.printJson((Node)newTrait.toNode())));
            }
        }
    }

    private boolean isInconsequentialRemovalOfDefaultTrait(Model model, DefaultTrait trait, Shape removedFrom) {
        return removedFrom.asMemberShape().map(member -> {
            if (trait.toNode().isNullNode()) {
                Node targetDefault = model.expectShape(member.getTarget()).getTrait(DefaultTrait.class).map(AbstractTrait::toNode).orElse((Node)Node.nullNode());
                return targetDefault.isNullNode();
            }
            return false;
        }).orElse(false);
    }

    private void evaluateChangedTrait(Model model, MemberShape member, DefaultTrait oldTrait, DefaultTrait newTrait, List<ValidationEvent> events) {
        boolean newZeroValue;
        Shape target = model.expectShape(member.getTarget());
        Node oldValue = oldTrait.toNode();
        Node newValue = newTrait.toNode();
        boolean oldZeroValue = NullableIndex.isDefaultZeroValueOfTypeInV1((Node)oldValue, (ShapeType)target.getType());
        if (oldZeroValue == (newZeroValue = NullableIndex.isDefaultZeroValueOfTypeInV1((Node)newValue, (ShapeType)target.getType()))) {
            events.add(this.danger((Shape)member, (FromSourceLocation)newTrait, "Changing the @default value of a member is dangerous and could break previously generated code or lead to subtle errors. Do this only when strictly necessary. Old value: " + Node.printJson((Node)oldValue) + ". New value: " + Node.printJson((Node)newValue)));
        } else if (oldZeroValue) {
            events.add(this.error((Shape)member, (FromSourceLocation)newTrait, "The @default trait of this member changed from the zero value of the target shape, `" + Node.printJson((Node)oldValue) + "`, to a value that is not the zero value, `" + Node.printJson((Node)newValue) + "`. This will break previously generated code."));
        } else {
            events.add(this.error((Shape)member, (FromSourceLocation)newTrait, "The @default trait of this member changed from something other than the zero value of the target shape, `" + Node.printJson((Node)oldValue) + "`, to the zero value, `" + Node.printJson((Node)newValue) + "`. This will break previously generated code."));
        }
    }
}

