/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.diff.evaluators;

import java.util.List;
import java.util.stream.Collectors;
import software.amazon.smithy.diff.ChangedShape;
import software.amazon.smithy.diff.Differences;
import software.amazon.smithy.diff.evaluators.AbstractDiffEvaluator;
import software.amazon.smithy.model.shapes.Shape;
import software.amazon.smithy.model.shapes.ShapeType;
import software.amazon.smithy.model.traits.UniqueItemsTrait;
import software.amazon.smithy.model.validation.ValidationEvent;

public final class ChangedShapeType
extends AbstractDiffEvaluator {
    @Override
    public List<ValidationEvent> evaluate(Differences differences) {
        return differences.changedShapes().filter(diff -> diff.getOldShape().getType() != diff.getNewShape().getType()).filter(diff -> !this.expectedSetToListChange((ChangedShape<Shape>)diff)).map(diff -> this.error((Shape)diff.getNewShape(), String.format("Shape `%s` type was changed from `%s` to `%s`.", diff.getShapeId(), diff.getOldShape().getType(), diff.getNewShape().getType()))).collect(Collectors.toList());
    }

    private boolean expectedSetToListChange(ChangedShape<Shape> diff) {
        ShapeType oldType = diff.getOldShape().getType();
        ShapeType newType = diff.getNewShape().getType();
        if (oldType == ShapeType.SET && newType == ShapeType.LIST) {
            return diff.getNewShape().hasTrait(UniqueItemsTrait.class);
        }
        return false;
    }
}

