/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.diff.evaluators;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import software.amazon.smithy.diff.ChangedShape;
import software.amazon.smithy.diff.Differences;
import software.amazon.smithy.diff.evaluators.AbstractDiffEvaluator;
import software.amazon.smithy.model.shapes.Shape;
import software.amazon.smithy.model.traits.EnumConstantBody;
import software.amazon.smithy.model.traits.EnumTrait;
import software.amazon.smithy.model.validation.ValidationEvent;
import software.amazon.smithy.utils.OptionalUtils;
import software.amazon.smithy.utils.Pair;

public class ChangedEnumTrait
extends AbstractDiffEvaluator {
    @Override
    public List<ValidationEvent> evaluate(Differences differences) {
        return differences.changedShapes().flatMap(change -> OptionalUtils.stream(change.getChangedTrait(EnumTrait.class)).map(p -> Pair.of((Object)change, (Object)p))).flatMap(pair -> this.validateEnum((ChangedShape)pair.getLeft(), (Pair<EnumTrait, EnumTrait>)((Pair)pair.getRight())).stream()).collect(Collectors.toList());
    }

    private List<ValidationEvent> validateEnum(ChangedShape<Shape> change, Pair<EnumTrait, EnumTrait> trait) {
        EnumTrait oldTrait = (EnumTrait)trait.getLeft();
        EnumTrait newTrait = (EnumTrait)trait.getRight();
        ArrayList<ValidationEvent> events = new ArrayList<ValidationEvent>();
        oldTrait.getValues().forEach((key, value) -> {
            if (!newTrait.getValues().containsKey(key)) {
                events.add(this.error((Shape)change.getNewShape(), String.format("Enum value `%s` was removed", key)));
            } else {
                EnumConstantBody newValue = (EnumConstantBody)newTrait.getValues().get(key);
                if (!newValue.getName().equals(value.getName())) {
                    events.add(this.error((Shape)change.getNewShape(), String.format("Enum `name` changed from `%s` to `%s` for the `%s` value", value.getName().orElse(null), newValue.getName().orElse(null), key)));
                }
            }
        });
        newTrait.getValues().forEach((key, value) -> {
            if (!oldTrait.getValues().containsKey(key)) {
                events.add(this.note((Shape)change.getNewShape(), String.format("Enum value `%s` was added", key)));
            }
        });
        return events;
    }
}

