/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.diff.evaluators;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import software.amazon.smithy.diff.ChangedShape;
import software.amazon.smithy.diff.Differences;
import software.amazon.smithy.diff.evaluators.AbstractDiffEvaluator;
import software.amazon.smithy.model.shapes.EntityShape;
import software.amazon.smithy.model.shapes.Shape;
import software.amazon.smithy.model.shapes.ShapeId;
import software.amazon.smithy.model.validation.Severity;
import software.amazon.smithy.model.validation.ValidationEvent;

public class RemovedEntityBinding
extends AbstractDiffEvaluator {
    private static final String REMOVED_RESOURCE = "RemovedResourceBinding";
    private static final String REMOVED_OPERATION = "RemovedOperationBinding";

    @Override
    public List<ValidationEvent> evaluate(Differences differences) {
        ArrayList<ValidationEvent> events = new ArrayList<ValidationEvent>();
        differences.changedShapes(EntityShape.class).forEach(change -> this.validateOperation((ChangedShape<EntityShape>)change, (List<ValidationEvent>)events));
        return events;
    }

    private void validateOperation(ChangedShape<EntityShape> change, List<ValidationEvent> events) {
        this.findRemoved(change.getOldShape().getOperations(), change.getNewShape().getOperations()).forEach(removed -> events.add(this.createRemovedEvent(REMOVED_OPERATION, (EntityShape)change.getNewShape(), (ShapeId)removed)));
        this.findRemoved(change.getOldShape().getResources(), change.getNewShape().getResources()).forEach(removed -> events.add(this.createRemovedEvent(REMOVED_RESOURCE, (EntityShape)change.getNewShape(), (ShapeId)removed)));
    }

    private Set<ShapeId> findRemoved(Set<ShapeId> oldShapes, Set<ShapeId> newShapes) {
        HashSet<ShapeId> removed = new HashSet<ShapeId>(oldShapes);
        removed.removeAll(newShapes);
        return removed;
    }

    private ValidationEvent createRemovedEvent(String eventId, EntityShape entity, ShapeId removedShape) {
        String descriptor = eventId.equals(REMOVED_RESOURCE) ? "Resource" : "Operation";
        String message = String.format("%s binding of `%s` was removed from %s shape, `%s`", descriptor, removedShape, entity.getType(), entity.getId());
        return ValidationEvent.builder().eventId(eventId).severity(Severity.ERROR).shape((Shape)entity).message(message).build();
    }
}

