/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.cli.shaded.eclipse.sisu.space;

import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.Writer;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.util.Elements;
import javax.tools.Diagnostic;
import javax.tools.FileObject;
import javax.tools.JavaFileManager;
import javax.tools.StandardLocation;
import software.amazon.smithy.cli.shaded.eclipse.sisu.space.AbstractSisuIndex;
import software.amazon.smithy.cli.shaded.eclipse.sisu.space.Tokens;
import software.amazon.smithy.cli.shaded.javax.annotation.processing.Completion;
import software.amazon.smithy.cli.shaded.javax.annotation.processing.ProcessingEnvironment;
import software.amazon.smithy.cli.shaded.javax.annotation.processing.Processor;
import software.amazon.smithy.cli.shaded.javax.annotation.processing.RoundEnvironment;
import software.amazon.smithy.cli.shaded.javax.inject.Qualifier;

public final class SisuIndexAPT6
extends AbstractSisuIndex
implements Processor {
    private static final String QUALIFIERS = "sisu.qualifiers";
    private static final String ALL = "all";
    private static final String NONE = "none";
    private static final boolean HAS_QUALIFIER;
    private ProcessingEnvironment environment;
    private String qualifiers;

    public void init(ProcessingEnvironment _environment) {
        this.environment = _environment;
        this.qualifiers = (String)_environment.getOptions().get(QUALIFIERS);
        if (null == this.qualifiers) {
            this.qualifiers = System.getProperty(QUALIFIERS);
        }
    }

    public boolean process(Set<? extends TypeElement> annotations, RoundEnvironment round) {
        Elements elementUtils = this.environment.getElementUtils();
        for (TypeElement typeElement : annotations) {
            if (ALL.equals(this.qualifiers) && !SisuIndexAPT6.hasQualifier(typeElement)) continue;
            for (Element elem : round.getElementsAnnotatedWith(typeElement)) {
                if (!elem.getKind().isClass()) continue;
                this.addClassToIndex("software.amazon.smithy.cli.shaded.javax.inject.Named", elementUtils.getBinaryName((TypeElement)elem));
            }
        }
        if (round.processingOver()) {
            this.flushIndex();
        }
        return false;
    }

    public Iterable<? extends Completion> getCompletions(Element element, AnnotationMirror annotation, ExecutableElement member, String userText) {
        return Collections.emptySet();
    }

    public Set<String> getSupportedAnnotationTypes() {
        if (ALL.equalsIgnoreCase(this.qualifiers)) {
            return Collections.singleton("*");
        }
        if (NONE.equalsIgnoreCase(this.qualifiers)) {
            return Collections.emptySet();
        }
        if (this.qualifiers != null && this.qualifiers.length() > 0) {
            HashSet<String> annotationTypes = new HashSet<String>();
            for (String type : Tokens.splitByComma(this.qualifiers)) {
                annotationTypes.add(type);
            }
            return annotationTypes;
        }
        return Collections.singleton("software.amazon.smithy.cli.shaded.javax.inject.Named");
    }

    public Set<String> getSupportedOptions() {
        return Collections.singleton(QUALIFIERS);
    }

    public SourceVersion getSupportedSourceVersion() {
        return SourceVersion.latestSupported();
    }

    @Override
    protected void info(String msg) {
        this.environment.getMessager().printMessage(Diagnostic.Kind.NOTE, (CharSequence)msg);
    }

    @Override
    protected void warn(String msg) {
        this.environment.getMessager().printMessage(Diagnostic.Kind.WARNING, (CharSequence)msg);
    }

    @Override
    protected Reader getReader(String path) throws IOException {
        FileObject file = this.environment.getFiler().getResource((JavaFileManager.Location)StandardLocation.CLASS_OUTPUT, (CharSequence)"", (CharSequence)path);
        return new InputStreamReader(file.openInputStream(), "UTF-8");
    }

    @Override
    protected Writer getWriter(String path) throws IOException {
        return this.environment.getFiler().createResource((JavaFileManager.Location)StandardLocation.CLASS_OUTPUT, (CharSequence)"", (CharSequence)path, new Element[0]).openWriter();
    }

    private static boolean hasQualifier(TypeElement anno) {
        if (HAS_QUALIFIER) {
            return null != anno.getAnnotation(Qualifier.class);
        }
        for (AnnotationMirror annotationMirror : anno.getAnnotationMirrors()) {
            if (!"software.amazon.smithy.cli.shaded.javax.inject.Qualifier".equals(annotationMirror.getAnnotationType().toString())) continue;
            return true;
        }
        return false;
    }

    static {
        boolean hasQualifier;
        try {
            hasQualifier = Qualifier.class.isAnnotation();
        }
        catch (LinkageError e) {
            hasQualifier = false;
        }
        HAS_QUALIFIER = hasQualifier;
    }
}

