/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.cli.shaded.apache.maven.repository.internal;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import software.amazon.smithy.cli.shaded.apache.maven.model.DependencyManagement;
import software.amazon.smithy.cli.shaded.apache.maven.model.DistributionManagement;
import software.amazon.smithy.cli.shaded.apache.maven.model.License;
import software.amazon.smithy.cli.shaded.apache.maven.model.Model;
import software.amazon.smithy.cli.shaded.apache.maven.model.Prerequisites;
import software.amazon.smithy.cli.shaded.apache.maven.model.Repository;
import software.amazon.smithy.cli.shaded.apache.maven.repository.internal.ArtifactDescriptorUtils;
import software.amazon.smithy.cli.shaded.eclipse.aether.RepositorySystemSession;
import software.amazon.smithy.cli.shaded.eclipse.aether.artifact.Artifact;
import software.amazon.smithy.cli.shaded.eclipse.aether.artifact.ArtifactType;
import software.amazon.smithy.cli.shaded.eclipse.aether.artifact.ArtifactTypeRegistry;
import software.amazon.smithy.cli.shaded.eclipse.aether.artifact.DefaultArtifact;
import software.amazon.smithy.cli.shaded.eclipse.aether.artifact.DefaultArtifactType;
import software.amazon.smithy.cli.shaded.eclipse.aether.graph.Dependency;
import software.amazon.smithy.cli.shaded.eclipse.aether.graph.Exclusion;
import software.amazon.smithy.cli.shaded.eclipse.aether.resolution.ArtifactDescriptorResult;

public class ArtifactDescriptorReaderDelegate {
    public void populateResult(RepositorySystemSession session, ArtifactDescriptorResult result, Model model) {
        ArtifactTypeRegistry stereotypes = session.getArtifactTypeRegistry();
        for (Repository repository : model.getRepositories()) {
            result.addRepository(ArtifactDescriptorUtils.toRemoteRepository(repository));
        }
        for (software.amazon.smithy.cli.shaded.apache.maven.model.Dependency dependency : model.getDependencies()) {
            result.addDependency(this.convert(dependency, stereotypes));
        }
        DependencyManagement mgmt = model.getDependencyManagement();
        if (mgmt != null) {
            for (software.amazon.smithy.cli.shaded.apache.maven.model.Dependency dependency : mgmt.getDependencies()) {
                result.addManagedDependency(this.convert(dependency, stereotypes));
            }
        }
        LinkedHashMap<String, Object> linkedHashMap = new LinkedHashMap<String, Object>();
        Prerequisites prerequisites = model.getPrerequisites();
        if (prerequisites != null) {
            linkedHashMap.put("prerequisites.maven", prerequisites.getMaven());
        }
        List<License> licenses = model.getLicenses();
        linkedHashMap.put("license.count", licenses.size());
        for (int i = 0; i < licenses.size(); ++i) {
            License license = licenses.get(i);
            linkedHashMap.put("license." + i + ".name", license.getName());
            linkedHashMap.put("license." + i + ".url", license.getUrl());
            linkedHashMap.put("license." + i + ".comments", license.getComments());
            linkedHashMap.put("license." + i + ".distribution", license.getDistribution());
        }
        result.setProperties(linkedHashMap);
        this.setArtifactProperties(result, model);
    }

    private Dependency convert(software.amazon.smithy.cli.shaded.apache.maven.model.Dependency dependency, ArtifactTypeRegistry stereotypes) {
        ArtifactType stereotype = stereotypes.get(dependency.getType());
        if (stereotype == null) {
            stereotype = new DefaultArtifactType(dependency.getType());
        }
        boolean system = dependency.getSystemPath() != null && !dependency.getSystemPath().isEmpty();
        Map<String, String> props = null;
        if (system) {
            props = Collections.singletonMap("localPath", dependency.getSystemPath());
        }
        DefaultArtifact artifact = new DefaultArtifact(dependency.getGroupId(), dependency.getArtifactId(), dependency.getClassifier(), null, dependency.getVersion(), props, stereotype);
        ArrayList<Exclusion> exclusions = new ArrayList<Exclusion>(dependency.getExclusions().size());
        for (software.amazon.smithy.cli.shaded.apache.maven.model.Exclusion exclusion : dependency.getExclusions()) {
            exclusions.add(this.convert(exclusion));
        }
        Dependency result = new Dependency((Artifact)artifact, dependency.getScope(), dependency.getOptional() != null ? Boolean.valueOf(dependency.isOptional()) : null, exclusions);
        return result;
    }

    private Exclusion convert(software.amazon.smithy.cli.shaded.apache.maven.model.Exclusion exclusion) {
        return new Exclusion(exclusion.getGroupId(), exclusion.getArtifactId(), "*", "*");
    }

    private void setArtifactProperties(ArtifactDescriptorResult result, Model model) {
        String downloadUrl = null;
        DistributionManagement distMgmt = model.getDistributionManagement();
        if (distMgmt != null) {
            downloadUrl = distMgmt.getDownloadUrl();
        }
        if (downloadUrl != null && !downloadUrl.isEmpty()) {
            Artifact artifact = result.getArtifact();
            HashMap<String, String> props = new HashMap<String, String>(artifact.getProperties());
            props.put("downloadUrl", downloadUrl);
            result.setArtifact(artifact.setProperties(props));
        }
    }
}

