/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.cli.shaded.eclipse.aether.internal.impl;

import java.util.Objects;
import software.amazon.smithy.cli.shaded.eclipse.aether.RepositorySystemSession;
import software.amazon.smithy.cli.shaded.eclipse.aether.internal.impl.DefaultLocalPathPrefixComposerFactory;
import software.amazon.smithy.cli.shaded.eclipse.aether.internal.impl.EnhancedLocalRepositoryManager;
import software.amazon.smithy.cli.shaded.eclipse.aether.internal.impl.LocalPathComposer;
import software.amazon.smithy.cli.shaded.eclipse.aether.internal.impl.LocalPathPrefixComposerFactory;
import software.amazon.smithy.cli.shaded.eclipse.aether.internal.impl.TrackingFileManager;
import software.amazon.smithy.cli.shaded.eclipse.aether.repository.LocalRepository;
import software.amazon.smithy.cli.shaded.eclipse.aether.repository.LocalRepositoryManager;
import software.amazon.smithy.cli.shaded.eclipse.aether.repository.NoLocalRepositoryManagerException;
import software.amazon.smithy.cli.shaded.eclipse.aether.spi.localrepo.LocalRepositoryManagerFactory;
import software.amazon.smithy.cli.shaded.eclipse.aether.spi.locator.Service;
import software.amazon.smithy.cli.shaded.eclipse.aether.spi.locator.ServiceLocator;
import software.amazon.smithy.cli.shaded.eclipse.aether.util.ConfigUtils;
import software.amazon.smithy.cli.shaded.javax.inject.Inject;
import software.amazon.smithy.cli.shaded.javax.inject.Named;
import software.amazon.smithy.cli.shaded.javax.inject.Singleton;

@Singleton
@Named(value="enhanced")
public class EnhancedLocalRepositoryManagerFactory
implements LocalRepositoryManagerFactory,
Service {
    public static final String NAME = "enhanced";
    private static final String CONFIG_PROP_TRACKING_FILENAME = "aether.enhancedLocalRepository.trackingFilename";
    private static final String DEFAULT_TRACKING_FILENAME = "_remote.repositories";
    private float priority = 10.0f;
    private LocalPathComposer localPathComposer;
    private TrackingFileManager trackingFileManager;
    private LocalPathPrefixComposerFactory localPathPrefixComposerFactory;

    @Deprecated
    public EnhancedLocalRepositoryManagerFactory() {
    }

    @Inject
    public EnhancedLocalRepositoryManagerFactory(LocalPathComposer localPathComposer, TrackingFileManager trackingFileManager, LocalPathPrefixComposerFactory localPathPrefixComposerFactory) {
        this.localPathComposer = Objects.requireNonNull(localPathComposer);
        this.trackingFileManager = Objects.requireNonNull(trackingFileManager);
        this.localPathPrefixComposerFactory = Objects.requireNonNull(localPathPrefixComposerFactory);
    }

    @Override
    public void initService(ServiceLocator locator) {
        this.localPathComposer = Objects.requireNonNull(locator.getService(LocalPathComposer.class));
        this.trackingFileManager = Objects.requireNonNull(locator.getService(TrackingFileManager.class));
        this.localPathPrefixComposerFactory = new DefaultLocalPathPrefixComposerFactory();
    }

    @Override
    public LocalRepositoryManager newInstance(RepositorySystemSession session, LocalRepository repository) throws NoLocalRepositoryManagerException {
        Objects.requireNonNull(session, "session cannot be null");
        Objects.requireNonNull(repository, "repository cannot be null");
        String trackingFilename = ConfigUtils.getString(session, "", CONFIG_PROP_TRACKING_FILENAME);
        if (trackingFilename.isEmpty() || trackingFilename.contains("/") || trackingFilename.contains("\\") || trackingFilename.contains("..")) {
            trackingFilename = DEFAULT_TRACKING_FILENAME;
        }
        if ("".equals(repository.getContentType()) || "default".equals(repository.getContentType())) {
            return new EnhancedLocalRepositoryManager(repository.getBasedir(), this.localPathComposer, trackingFilename, this.trackingFileManager, this.localPathPrefixComposerFactory.createComposer(session));
        }
        throw new NoLocalRepositoryManagerException(repository);
    }

    @Override
    public float getPriority() {
        return this.priority;
    }

    public EnhancedLocalRepositoryManagerFactory setPriority(float priority) {
        this.priority = priority;
        return this;
    }
}

