/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.cli.shaded.eclipse.sisu.space;

import com.google.inject.Module;
import java.net.URL;
import software.amazon.smithy.cli.shaded.eclipse.sisu.inject.Logs;
import software.amazon.smithy.cli.shaded.eclipse.sisu.space.AnnotationVisitor;
import software.amazon.smithy.cli.shaded.eclipse.sisu.space.ClassSpace;
import software.amazon.smithy.cli.shaded.eclipse.sisu.space.ClassVisitor;
import software.amazon.smithy.cli.shaded.eclipse.sisu.space.QualifiedTypeListener;
import software.amazon.smithy.cli.shaded.eclipse.sisu.space.QualifierCache;
import software.amazon.smithy.cli.shaded.eclipse.sisu.space.SpaceVisitor;
import software.amazon.smithy.cli.shaded.javax.inject.Qualifier;

public final class QualifiedTypeVisitor
implements SpaceVisitor,
ClassVisitor {
    private final QualifierCache qualifierCache;
    private final QualifiedTypeListener listener;
    private ClassSpace space;
    private URL location;
    private String source;
    private String clazzName;
    private boolean qualified;

    public QualifiedTypeVisitor(QualifiedTypeListener listener) {
        this(listener, false);
    }

    public QualifiedTypeVisitor(QualifiedTypeListener listener, boolean isStrict) {
        this.qualifierCache = new QualifierCache(isStrict);
        this.listener = listener;
    }

    public static boolean verify(ClassSpace space, Class<?> ... specification) {
        for (Class<?> expectedClazz : specification) {
            try {
                Class<?> spaceClazz = space.loadClass(expectedClazz.getName());
                if (spaceClazz == expectedClazz) continue;
                Logs.warn("Inconsistent ClassLoader for: {} in: {}", expectedClazz, space);
                Logs.warn("Expected: {} saw: {}", expectedClazz.getClassLoader(), spaceClazz.getClassLoader());
            }
            catch (TypeNotPresentException e) {
                if (!expectedClazz.isAnnotation()) continue;
                Logs.debug("Potential problem: {} is not visible from: {}", expectedClazz, space);
            }
        }
        return true;
    }

    @Override
    public void enterSpace(ClassSpace _space) {
        this.space = _space;
        this.source = null;
        if (Logs.TRACE_ENABLED) {
            QualifiedTypeVisitor.verify(_space, Qualifier.class, Module.class);
        }
    }

    @Override
    public ClassVisitor visitClass(URL url) {
        this.location = url;
        this.clazzName = null;
        this.qualified = false;
        return this;
    }

    @Override
    public void enterClass(int modifiers, String name, String _extends, String[] _implements) {
        if ((modifiers & 0x7600) == 0) {
            this.clazzName = name;
        }
    }

    @Override
    public AnnotationVisitor visitAnnotation(String desc) {
        if (null != this.clazzName) {
            this.qualified = this.qualified || this.qualifierCache.qualify(this.space, desc);
        }
        return null;
    }

    public void disqualify() {
        this.qualified = false;
    }

    @Override
    public void leaveClass() {
        if (this.qualified) {
            this.listener.hear(this.space.loadClass(this.clazzName.replace('/', '.')), this.findSource());
        }
    }

    @Override
    public void leaveSpace() {
    }

    private String findSource() {
        if (null != this.location) {
            String path = this.location.getPath();
            if (null == this.source || !path.startsWith(this.source)) {
                int i = path.indexOf(this.clazzName);
                this.source = i <= 0 ? path : path.substring(0, i);
            }
        } else if (null == this.source) {
            this.source = this.space.toString();
        }
        return this.source;
    }
}

