/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.cli.shaded.apache.maven.model.path;

import software.amazon.smithy.cli.shaded.apache.maven.model.DistributionManagement;
import software.amazon.smithy.cli.shaded.apache.maven.model.Model;
import software.amazon.smithy.cli.shaded.apache.maven.model.Scm;
import software.amazon.smithy.cli.shaded.apache.maven.model.Site;
import software.amazon.smithy.cli.shaded.apache.maven.model.building.ModelBuildingRequest;
import software.amazon.smithy.cli.shaded.apache.maven.model.path.ModelUrlNormalizer;
import software.amazon.smithy.cli.shaded.apache.maven.model.path.UrlNormalizer;
import software.amazon.smithy.cli.shaded.javax.inject.Inject;
import software.amazon.smithy.cli.shaded.javax.inject.Named;
import software.amazon.smithy.cli.shaded.javax.inject.Singleton;

@Named
@Singleton
public class DefaultModelUrlNormalizer
implements ModelUrlNormalizer {
    @Inject
    private UrlNormalizer urlNormalizer;

    public DefaultModelUrlNormalizer setUrlNormalizer(UrlNormalizer urlNormalizer) {
        this.urlNormalizer = urlNormalizer;
        return this;
    }

    @Override
    public void normalize(Model model, ModelBuildingRequest request) {
        Site site;
        DistributionManagement dist;
        if (model == null) {
            return;
        }
        model.setUrl(this.normalize(model.getUrl()));
        Scm scm = model.getScm();
        if (scm != null) {
            scm.setUrl(this.normalize(scm.getUrl()));
            scm.setConnection(this.normalize(scm.getConnection()));
            scm.setDeveloperConnection(this.normalize(scm.getDeveloperConnection()));
        }
        if ((dist = model.getDistributionManagement()) != null && (site = dist.getSite()) != null) {
            site.setUrl(this.normalize(site.getUrl()));
        }
    }

    private String normalize(String url) {
        return this.urlNormalizer.normalize(url);
    }
}

