/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.cli.shaded.eclipse.aether.internal.impl;

import java.io.File;
import java.util.Objects;
import java.util.TreeSet;
import software.amazon.smithy.cli.shaded.eclipse.aether.RepositorySystemSession;
import software.amazon.smithy.cli.shaded.eclipse.aether.artifact.Artifact;
import software.amazon.smithy.cli.shaded.eclipse.aether.internal.impl.LocalPathComposer;
import software.amazon.smithy.cli.shaded.eclipse.aether.metadata.Metadata;
import software.amazon.smithy.cli.shaded.eclipse.aether.repository.LocalArtifactRegistration;
import software.amazon.smithy.cli.shaded.eclipse.aether.repository.LocalArtifactRequest;
import software.amazon.smithy.cli.shaded.eclipse.aether.repository.LocalArtifactResult;
import software.amazon.smithy.cli.shaded.eclipse.aether.repository.LocalMetadataRegistration;
import software.amazon.smithy.cli.shaded.eclipse.aether.repository.LocalMetadataRequest;
import software.amazon.smithy.cli.shaded.eclipse.aether.repository.LocalMetadataResult;
import software.amazon.smithy.cli.shaded.eclipse.aether.repository.LocalRepository;
import software.amazon.smithy.cli.shaded.eclipse.aether.repository.LocalRepositoryManager;
import software.amazon.smithy.cli.shaded.eclipse.aether.repository.RemoteRepository;
import software.amazon.smithy.cli.shaded.eclipse.aether.util.StringDigestUtil;

class SimpleLocalRepositoryManager
implements LocalRepositoryManager {
    private final LocalRepository repository;
    private final LocalPathComposer localPathComposer;

    SimpleLocalRepositoryManager(File basedir, String type, LocalPathComposer localPathComposer) {
        Objects.requireNonNull(basedir, "base directory cannot be null");
        this.repository = new LocalRepository(basedir.getAbsoluteFile(), type);
        this.localPathComposer = Objects.requireNonNull(localPathComposer);
    }

    @Override
    public LocalRepository getRepository() {
        return this.repository;
    }

    @Override
    public String getPathForLocalArtifact(Artifact artifact) {
        Objects.requireNonNull(artifact, "artifact cannot be null");
        return this.localPathComposer.getPathForArtifact(artifact, true);
    }

    @Override
    public String getPathForRemoteArtifact(Artifact artifact, RemoteRepository repository, String context) {
        Objects.requireNonNull(artifact, "artifact cannot be null");
        Objects.requireNonNull(repository, "repository cannot be null");
        return this.localPathComposer.getPathForArtifact(artifact, false);
    }

    @Override
    public String getPathForLocalMetadata(Metadata metadata) {
        Objects.requireNonNull(metadata, "metadata cannot be null");
        return this.localPathComposer.getPathForMetadata(metadata, "local");
    }

    @Override
    public String getPathForRemoteMetadata(Metadata metadata, RemoteRepository repository, String context) {
        Objects.requireNonNull(metadata, "metadata cannot be null");
        Objects.requireNonNull(repository, "repository cannot be null");
        return this.localPathComposer.getPathForMetadata(metadata, this.getRepositoryKey(repository, context));
    }

    protected String getRepositoryKey(RemoteRepository repository, String context) {
        String key;
        if (repository.isRepositoryManager()) {
            StringBuilder buffer = new StringBuilder(128);
            buffer.append(repository.getId());
            buffer.append('-');
            TreeSet<String> subKeys = new TreeSet<String>();
            for (RemoteRepository mirroredRepo : repository.getMirroredRepositories()) {
                subKeys.add(mirroredRepo.getId());
            }
            StringDigestUtil sha1 = StringDigestUtil.sha1();
            sha1.update(context);
            for (String subKey : subKeys) {
                sha1.update(subKey);
            }
            buffer.append(sha1.digest());
            key = buffer.toString();
        } else {
            key = repository.getId();
        }
        return key;
    }

    @Override
    public LocalArtifactResult find(RepositorySystemSession session, LocalArtifactRequest request) {
        File file;
        String path;
        Objects.requireNonNull(session, "session cannot be null");
        Objects.requireNonNull(request, "request cannot be null");
        Artifact artifact = request.getArtifact();
        LocalArtifactResult result = new LocalArtifactResult(request);
        if (Objects.equals(artifact.getVersion(), artifact.getBaseVersion())) {
            path = this.getPathForLocalArtifact(artifact);
            file = new File(this.getRepository().getBasedir(), path);
            if (file.isFile()) {
                result.setFile(file);
                result.setAvailable(true);
            }
        }
        if (!result.isAvailable()) {
            for (RemoteRepository repository : request.getRepositories()) {
                path = this.getPathForRemoteArtifact(artifact, repository, request.getContext());
                file = new File(this.getRepository().getBasedir(), path);
                if (!file.isFile()) continue;
                result.setFile(file);
                result.setAvailable(true);
                break;
            }
        }
        return result;
    }

    @Override
    public void add(RepositorySystemSession session, LocalArtifactRegistration request) {
        Objects.requireNonNull(session, "session cannot be null");
        Objects.requireNonNull(request, "request cannot be null");
    }

    @Override
    public LocalMetadataResult find(RepositorySystemSession session, LocalMetadataRequest request) {
        Objects.requireNonNull(session, "session cannot be null");
        Objects.requireNonNull(request, "request cannot be null");
        LocalMetadataResult result = new LocalMetadataResult(request);
        Metadata metadata = request.getMetadata();
        String context = request.getContext();
        RemoteRepository remote = request.getRepository();
        String path = remote != null ? this.getPathForRemoteMetadata(metadata, remote, context) : this.getPathForLocalMetadata(metadata);
        File file = new File(this.getRepository().getBasedir(), path);
        if (file.isFile()) {
            result.setFile(file);
        }
        return result;
    }

    @Override
    public void add(RepositorySystemSession session, LocalMetadataRegistration request) {
        Objects.requireNonNull(session, "session cannot be null");
        Objects.requireNonNull(request, "request cannot be null");
    }

    public String toString() {
        return String.valueOf(this.getRepository());
    }
}

