/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.cli;

import java.util.function.Consumer;
import java.util.logging.Level;
import software.amazon.smithy.cli.AnsiColorFormatter;
import software.amazon.smithy.cli.ArgumentReceiver;
import software.amazon.smithy.cli.CliError;
import software.amazon.smithy.cli.HelpPrinter;

public final class StandardOptions
implements ArgumentReceiver {
    public static final String HELP_SHORT = "-h";
    public static final String HELP = "--help";
    public static final String DEBUG = "--debug";
    public static final String QUIET = "--quiet";
    public static final String STACKTRACE = "--stacktrace";
    public static final String NO_COLOR = "--no-color";
    public static final String FORCE_COLOR = "--force-color";
    public static final String LOGGING = "--logging";
    private boolean help;
    private Level logging = Level.WARNING;
    private boolean quiet;
    private boolean debug;
    private boolean stackTrace;
    private AnsiColorFormatter colorSetting = AnsiColorFormatter.AUTO;

    @Override
    public void registerHelp(HelpPrinter printer) {
        printer.option(HELP, HELP_SHORT, "Print this help output.");
        printer.option(DEBUG, null, "Display debug information.");
        printer.option(QUIET, null, "Silence output except errors.");
        printer.option(NO_COLOR, null, "Disable ANSI colors.");
        printer.option(FORCE_COLOR, null, "Force the use of ANSI colors.");
        printer.option(STACKTRACE, null, "Display a stacktrace on error.");
        printer.param(LOGGING, null, "LOG_LEVEL", "Set the log level (defaults to WARNING). Set to one of OFF, SEVERE, WARNING, INFO, FINE, ALL.");
    }

    @Override
    public boolean testOption(String name) {
        switch (name) {
            case "--help": 
            case "-h": {
                this.help = true;
                return true;
            }
            case "--debug": {
                this.debug = true;
                this.quiet = false;
                this.logging = Level.ALL;
                return true;
            }
            case "--quiet": {
                this.quiet = true;
                this.debug = false;
                this.logging = Level.SEVERE;
                return true;
            }
            case "--stacktrace": {
                this.stackTrace = true;
                return true;
            }
            case "--no-color": {
                this.colorSetting = AnsiColorFormatter.NO_COLOR;
                return true;
            }
            case "--force-color": {
                this.colorSetting = AnsiColorFormatter.FORCE_COLOR;
                return true;
            }
        }
        return false;
    }

    @Override
    public Consumer<String> testParameter(String name) {
        if (LOGGING.equals(name)) {
            return value -> {
                try {
                    this.logging = Level.parse(value);
                }
                catch (IllegalArgumentException e) {
                    throw new CliError("Invalid logging level: " + value);
                }
            };
        }
        return null;
    }

    public boolean help() {
        return this.help;
    }

    public Level logging() {
        return this.logging;
    }

    public boolean quiet() {
        return this.quiet;
    }

    public boolean debug() {
        return this.debug;
    }

    public boolean stackTrace() {
        return this.stackTrace;
    }

    public AnsiColorFormatter colorSetting() {
        return this.colorSetting;
    }
}

