/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.cli.shaded.apache.maven.repository.internal;

import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.Date;
import java.util.Map;
import software.amazon.smithy.cli.shaded.apache.maven.artifact.repository.metadata.Metadata;
import software.amazon.smithy.cli.shaded.apache.maven.artifact.repository.metadata.io.xpp3.MetadataXpp3Reader;
import software.amazon.smithy.cli.shaded.apache.maven.artifact.repository.metadata.io.xpp3.MetadataXpp3Writer;
import software.amazon.smithy.cli.shaded.codehaus.plexus.util.ReaderFactory;
import software.amazon.smithy.cli.shaded.codehaus.plexus.util.WriterFactory;
import software.amazon.smithy.cli.shaded.codehaus.plexus.util.xml.XmlStreamReader;
import software.amazon.smithy.cli.shaded.codehaus.plexus.util.xml.XmlStreamWriter;
import software.amazon.smithy.cli.shaded.codehaus.plexus.util.xml.pull.XmlPullParserException;
import software.amazon.smithy.cli.shaded.eclipse.aether.RepositoryException;
import software.amazon.smithy.cli.shaded.eclipse.aether.metadata.AbstractMetadata;
import software.amazon.smithy.cli.shaded.eclipse.aether.metadata.MergeableMetadata;

abstract class MavenMetadata
extends AbstractMetadata
implements MergeableMetadata {
    static final String MAVEN_METADATA_XML = "maven-metadata.xml";
    protected Metadata metadata;
    private final File file;
    protected final Date timestamp;
    private boolean merged;

    protected MavenMetadata(Metadata metadata, File file, Date timestamp) {
        this.metadata = metadata;
        this.file = file;
        this.timestamp = timestamp;
    }

    @Override
    public String getType() {
        return MAVEN_METADATA_XML;
    }

    @Override
    public File getFile() {
        return this.file;
    }

    @Override
    public void merge(File existing, File result) throws RepositoryException {
        Metadata recessive = MavenMetadata.read(existing);
        this.merge(recessive);
        this.write(result, this.metadata);
        this.merged = true;
    }

    @Override
    public boolean isMerged() {
        return this.merged;
    }

    protected abstract void merge(Metadata var1);

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static Metadata read(File metadataFile) throws RepositoryException {
        if (metadataFile.length() <= 0L) {
            return new Metadata();
        }
        try (XmlStreamReader reader = ReaderFactory.newXmlReader(metadataFile);){
            Metadata metadata = new MetadataXpp3Reader().read(reader, false);
            return metadata;
        }
        catch (IOException e) {
            throw new RepositoryException("Could not read metadata " + metadataFile + ": " + e.getMessage(), e);
        }
        catch (XmlPullParserException e) {
            throw new RepositoryException("Could not parse metadata " + metadataFile + ": " + e.getMessage(), e);
        }
    }

    private void write(File metadataFile, Metadata metadata) throws RepositoryException {
        metadataFile.getParentFile().mkdirs();
        try (XmlStreamWriter writer = WriterFactory.newXmlWriter(metadataFile);){
            new MetadataXpp3Writer().write(writer, metadata);
        }
        catch (IOException e) {
            throw new RepositoryException("Could not write metadata " + metadataFile + ": " + e.getMessage(), e);
        }
    }

    @Override
    public Map<String, String> getProperties() {
        return Collections.emptyMap();
    }

    @Override
    public software.amazon.smithy.cli.shaded.eclipse.aether.metadata.Metadata setProperties(Map<String, String> properties) {
        return this;
    }
}

