/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.cli.shaded.apache.http.protocol;

import java.io.IOException;
import software.amazon.smithy.cli.shaded.apache.http.Header;
import software.amazon.smithy.cli.shaded.apache.http.HttpEntity;
import software.amazon.smithy.cli.shaded.apache.http.HttpException;
import software.amazon.smithy.cli.shaded.apache.http.HttpRequest;
import software.amazon.smithy.cli.shaded.apache.http.HttpResponse;
import software.amazon.smithy.cli.shaded.apache.http.HttpResponseInterceptor;
import software.amazon.smithy.cli.shaded.apache.http.HttpVersion;
import software.amazon.smithy.cli.shaded.apache.http.ProtocolVersion;
import software.amazon.smithy.cli.shaded.apache.http.annotation.Contract;
import software.amazon.smithy.cli.shaded.apache.http.annotation.ThreadingBehavior;
import software.amazon.smithy.cli.shaded.apache.http.protocol.HttpContext;
import software.amazon.smithy.cli.shaded.apache.http.protocol.HttpCoreContext;
import software.amazon.smithy.cli.shaded.apache.http.util.Args;

@Contract(threading=ThreadingBehavior.IMMUTABLE)
public class ResponseConnControl
implements HttpResponseInterceptor {
    @Override
    public void process(HttpResponse response, HttpContext context) throws HttpException, IOException {
        HttpRequest request;
        Args.notNull(response, "HTTP response");
        HttpCoreContext corecontext = HttpCoreContext.adapt(context);
        int status = response.getStatusLine().getStatusCode();
        if (status == 400 || status == 408 || status == 411 || status == 413 || status == 414 || status == 503 || status == 501) {
            response.setHeader("Connection", "Close");
            return;
        }
        Header explicit = response.getFirstHeader("Connection");
        if (explicit != null && "Close".equalsIgnoreCase(explicit.getValue())) {
            return;
        }
        HttpEntity entity = response.getEntity();
        if (entity != null) {
            ProtocolVersion ver = response.getStatusLine().getProtocolVersion();
            if (entity.getContentLength() < 0L && (!entity.isChunked() || ver.lessEquals(HttpVersion.HTTP_1_0))) {
                response.setHeader("Connection", "Close");
                return;
            }
        }
        if ((request = corecontext.getRequest()) != null) {
            Header header = request.getFirstHeader("Connection");
            if (header != null) {
                response.setHeader("Connection", header.getValue());
            } else if (request.getProtocolVersion().lessEquals(HttpVersion.HTTP_1_0)) {
                response.setHeader("Connection", "Close");
            }
        }
    }
}

