/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.cli.shaded.eclipse.sisu.inject;

import com.google.inject.Binding;
import com.google.inject.Scopes;
import com.google.inject.spi.ElementSource;
import com.google.inject.spi.ProviderInstanceBinding;
import software.amazon.smithy.cli.shaded.javax.inject.Provider;

public final class Guice4 {
    private static final boolean HAS_DECLARING_SOURCE;
    private static final boolean HAS_USER_SUPPLIED_PROVIDER;
    private static final boolean HAS_OLD_SCOPES_SINGLETON;
    static final Object NIL;

    static {
        boolean hasOldScopesSingleton;
        boolean hasUserSuppliedProvider;
        boolean hasDeclaringSource;
        try {
            hasDeclaringSource = ElementSource.class.getMethod("getDeclaringSource", new Class[0]) != null;
        }
        catch (Exception exception) {
            hasDeclaringSource = false;
        }
        catch (LinkageError linkageError) {
            hasDeclaringSource = false;
        }
        HAS_DECLARING_SOURCE = hasDeclaringSource;
        try {
            hasUserSuppliedProvider = ProviderInstanceBinding.class.getMethod("getUserSuppliedProvider", new Class[0]) != null;
        }
        catch (Exception exception) {
            hasUserSuppliedProvider = false;
        }
        catch (LinkageError linkageError) {
            hasUserSuppliedProvider = false;
        }
        HAS_USER_SUPPLIED_PROVIDER = hasUserSuppliedProvider;
        try {
            hasOldScopesSingleton = Scopes.class.equals(Scopes.SINGLETON.getClass().getEnclosingClass()) && Scopes.SINGLETON.scope(null, null) != null;
        }
        catch (Exception exception) {
            hasOldScopesSingleton = false;
        }
        catch (LinkageError linkageError) {
            hasOldScopesSingleton = false;
        }
        HAS_OLD_SCOPES_SINGLETON = hasOldScopesSingleton;
        NIL = new Object();
    }

    private Guice4() {
    }

    public static Object getDeclaringSource(Binding<?> binding) {
        Object source = binding.getSource();
        if (HAS_DECLARING_SOURCE && source instanceof ElementSource) {
            return ((ElementSource)source).getDeclaringSource();
        }
        return source;
    }

    public static Provider<?> getProviderInstance(ProviderInstanceBinding<?> binding) {
        return HAS_USER_SUPPLIED_PROVIDER ? binding.getUserSuppliedProvider() : binding.getProviderInstance();
    }

    public static <T> Provider<T> lazy(Binding<T> binding) {
        if (HAS_OLD_SCOPES_SINGLETON) {
            return Scopes.SINGLETON.scope(binding.getKey(), binding.getProvider());
        }
        com.google.inject.Provider provider = binding.getProvider();
        return new Provider<T>((Provider)provider){
            private volatile Object value = NIL;
            private final /* synthetic */ Provider val$provider;
            {
                this.val$provider = provider;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public T get() {
                if (NIL == this.value) {
                    1 var1_1 = this;
                    synchronized (var1_1) {
                        if (NIL == this.value) {
                            this.value = this.val$provider.get();
                        }
                    }
                }
                return this.value;
            }
        };
    }
}

